#pragma once
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * $Id: 90c72d6cf6c5a1a2158e6eb622032e81338fcec8 $
 *
 * @file unlang/limit_priv.h
 *
 * @copyright 2022 Network RADIUS SAS (legal@networkradius.com)
 */
#ifdef __cplusplus
extern "C" {
#endif

#include <freeradius-devel/server/tmpl.h>

typedef struct {
	unlang_group_t	group;
	tmpl_t		*vpt;
	uint32_t	limit;
} unlang_limit_t;

/** Cast a group structure to the limit keyword extension
 *
 */
static inline unlang_limit_t *unlang_group_to_limit(unlang_group_t *g)
{
	return talloc_get_type_abort(g, unlang_limit_t);
}

/** Cast a limit keyword extension to a group structure
 *
 */
static inline unlang_group_t *unlang_limit_to_group(unlang_limit_t *li)
{
	return (unlang_group_t *)li;
}

#ifdef __cplusplus
}
#endif
