#pragma once
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * $Id: 17c1068defc9216ccf1a6dcf05d32d50b0f44111 $
 *
 * @file lib/server/pairmove.h
 * @brief Legacy pairmove function
 *
 * @copyright 2007 The FreeRADIUS server project
 * @copyright 2007 Alan DeKok (aland@deployingradius.com)
 */
RCSIDH(pairmove_h, "$Id: 17c1068defc9216ccf1a6dcf05d32d50b0f44111 $")

#include <freeradius-devel/server/request.h>
#include <freeradius-devel/server/map.h>
#include <freeradius-devel/util/edit.h>

#ifdef __cplusplus
extern "C" {
#endif

void	radius_pairmove(request_t *request, fr_pair_list_t *to, fr_pair_list_t *from) CC_HINT(nonnull);

int	radius_legacy_map_apply(request_t *request, map_t const *map, fr_edit_list_t *el) CC_HINT(nonnull(1,2));

int	radius_legacy_map_list_apply(request_t *request, map_list_t const *list, fr_edit_list_t *el) CC_HINT(nonnull(1,2));

int	radius_legacy_map_cmp(request_t *request, map_t const *map) CC_HINT(nonnull);

#ifdef __cplusplus
}
#endif
