#pragma once
/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * $Id: 5b69f481bb4019a8b370debb4c5f6e0d69296d27 $
 *
 * @file src/lib/server/module_method.h
 * @brief Defines standard module methods specified by virtual servers and modules.
 *
 * @copyright 2022 Arran Cudbard-Bell (a.cudbardb@freeradius.org)
 */
RCSIDH(module_method_h, "$Id: 5b69f481bb4019a8b370debb4c5f6e0d69296d27 $")

#ifdef __cplusplus
extern "C" {
#endif

#include <freeradius-devel/server/virtual_servers.h>

extern section_name_t module_method_ippool_allocate;

extern section_name_t module_method_ippool_extend;

extern section_name_t module_method_ippool_mark;

extern section_name_t module_method_ippool_release;

#ifdef __cplusplus
}
#endif
