#pragma once
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * $Id: f0601287744559918df67a158d9a095c234d5127 $
 *
 * @file lib/server/dependency.h
 * @brief Version checking functions
 *
 * @copyright 2017 The FreeRADIUS server project
 */
RCSIDH(dependency_h, "$Id: f0601287744559918df67a158d9a095c234d5127 $")

#ifdef __cplusplus
extern "C" {
#endif

extern char const	*radiusd_version;
extern char const	*radiusd_version_short;

#include <freeradius-devel/server/cf_util.h>

#include <stddef.h>

#define RADIUSD_VERSION_STRING STRINGIFY(RADIUSD_VERSION_MAJOR) "." STRINGIFY(RADIUSD_VERSION_MINOR) "." STRINGIFY(RADIUSD_VERSION_INCRM)

int		rad_check_lib_magic(uint64_t magic);
int		dependency_feature_add(CONF_SECTION *cs, char const *name, bool enabled);
int		dependency_version_number_add(CONF_SECTION *cs, char const *name, char const *version);
void		dependency_features_init(CONF_SECTION *cs) CC_HINT(nonnull);
void		dependency_version_numbers_init(CONF_SECTION *cs);
void		dependency_version_print(void);

#ifdef __cplusplus
}
#endif
