# Code of Conduct
## 1. Overview

The goal of the FreeRADIUS project is to produce reliable, feature-full software which benefits the
open source community.

The GitHub issue tracker and mailing lists have a strict code of conduct.

> Only technical discussion related to FreeRADIUS, the protocols it implements, and its dependencies
> are permitted in GitHub communications and on the mailing list.
>
> Please note that any off-topic discussion will result in a warning. Continued off topic discussion
> will result in the individual being unsubscribed from the mailing lists and/or permanent
> banishment from the GitHub repositories.

This code of conduct is simple to abide by, and is simple to enforce. Unlike other codes of conduct,
it does not require participants to be explicitly "inclusive" or "accepting" of certain topics. It
requires participants to be *blind* to non-technical subjects, as those subjects are explicitly off
topic. The FreeRADIUS community is inclusive by virtue of not being exclusionary.

If you believe that the implicit biases of community members may affect how your contributions are
evaluated, you are invited to anonymise your contributions.  You will not be penalised for use of
pseudonyms or anonymised identities when creating/signing patches, or posting on the mailing list(s).

## 2. Expected Behaviour

The following behaviours are expected and requested of all community members:

- Ensure that the rules of the community resource you're using have been reviewed in full, [mailing
  list guidelines](https://freeradius.org/support/) for the mailing lists, [the guidelines for
  contributing](https://github.com/FreeRADIUS/freeradius-server/blob/master/.github/contributing.md)
  for GitHub.
- Use a neutral tone with a focus on technical arguments and technical discussion.
- Evaluate contributions, ideas and feedback on technical merit only.  The personal attributes of
  community members are entirely irrelevant and comments of this nature will not be tolerated.
- Research topics using appropriate standards, design documents, and technical manuals before raising
  GitHub issues, or sending pull requests.

## 3. Unacceptable Behaviour

The main source of unacceptable behavior is community participants who are unaware of the
complexities of the software and protocols involved.
They have questions, and they want answers.  They believe that as the experts, we can answer any and
all questions about all possible technologies which interact with FreeRADIUS.

That expectation is unreasonable.  When that expectation turns to entitlement and anger, it becomes
unacceptable behaviour.

The following behaviours are also unacceptable within our community:

- Non-technical discussion.
- Ad hominem attacks and other personal attacks.
- Willful ignorance.
- Demands that questions be answered.
- Refusal to read documentation when pointed to it.
- Refusal to follow instructions for solving a problem.

## 4. Consequences of Unacceptable Behaviour

Where unacceptable behaviour is noted and the community participant informed of behaviour and next
steps, the community participant is expected to comply immediately.  Arguing with the warnings is
deemed "off topic" for the community (see section 1), and is seen as a continuance of the
unacceptable behavior.

The community organizers will take any action they deem appropriate, which may include permanent
expulsion from the community using appropriate mechanisms.

## 5. Our Limitations

We understand that when participants ask questions, their goal is to obtain help from the community.
Please be aware that the FreeRADIUS community is not large.  The project has three core members,
none of whom are dedicated 100% to FreeRADIUS.  The project has about seventy modules, each of which
has complex behavior.  All of that code, test cases, and documentation have to be updated with
limited resources.

We rely on well researched and technically sound contributions in order to make the project a
success.

## 6. Reporting Guidelines

If you are subject to or witness unacceptable behaviour or have any other concerns, please notify a
community organizer as soon as possible. social@freeradius.org.

## 7. Scope

We expect all community members, including those who contribute to the project financially or are in
positions of power within the community, to abide by this Code of Conduct in all venues and over all
communication mediums.

## 8. Contact info

social@freeradius.org
