# Usage

## Approaches
There are two approaches for using `angular-fontawesome`. Each has its own pros and cons, so we leave it to you to decide how you'd like to use the library.

* [Explicit Reference](./usage/explicit-reference.md)
* [Icon Library](./usage/icon-library.md)

Whichever approach you choose only the icons you have imported will end up in the bundle, and the remaining ones will be tree-shaken away.

## Using Additional Styles
Take advantage of the other FontAwesome icon styles.

* [Brand](./usage/using-other-styles.md#brand-icons)
* [Regular](./usage/using-other-styles.md#regular-icons)
* [Light (Pro Only)](./usage/using-other-styles.md#pro-only-light-icons)
* [Duotone (Pro Only)](./usage/using-other-styles.md#pro-only-duotone-icons)

## Features
Utilize core FontAwesome features

* [Size](./usage/features.md#size)
* [Fixed Width](./usage/features.md#fixed-width)
* [Rotate](./usage/features.md#rotate)
* [Flip](./usage/features.md#flip)
* [Animations](./usage/features.md#animations)
* [Border](./usage/features.md#border)
* [Pull](./usage/features.md#pull)
* [Custom styles](./usage/features.md#custom-styles)

## Features specific for Duotone icons
Additional features available for Duotone icons

* [Basic use](./usage/features.md#basic-use)
* [Swap layers opacity](./usage/features.md#swap-layers-opacity)
* [Customize layers opacity](./usage/features.md#customize-layers-opacity)
* [Customize layers color](./usage/features.md#customize-layers-color)

## Advanced Features
Take your icons to the next level with these advanced features.

* [Mask](./usage/features.md#mask)
* [Transform](./usage/features.md#transform)
* [Stateful Animations](./usage/features.md#stateful-animations)
* [Transform within binding](./usage/features.md#transform-within-binding)
* [Stacked icons](./usage/features.md#stacked-icons)
* [Layers](./usage/features.md#layers)
* [Layers with text](./usage/features.md#layers-with-text)
* [Layers with counter](./usage/features.md#layers-with-counter)
* [Programmatic API](./usage/features.md#programmatic-api)

## Guides
Guides on specific topics or use cases.

* [Testing](./guide/testing.md)
* [Custom icons](./guide/custom-icons.md)
* [Storybook](./guide/storybook.md)
* [Advanced uses](./guide/advanced-uses.md)
* [Styling icon internals](./guide/styling-icon-internals.md)
* [Adding CSS](./guide/adding-css.md)
