# Upgrading 0.5.0 to 0.6.0

## Migrate from global icon library to FaIconLibrary

See [upgrade instructions](https://github.com/FortAwesome/angular-fontawesome/blob/master/docs/upgrading/0.4.0-0.5.0.md#migrate-from-global-icon-library-to-faiconlibrary) for the previous release.

## `FaIcon.icon` and `FaDuotoneIcon.icon` inputs are now required

`icon` input of these components is now required and will throw an error if it is missing or set to `null` or `underfined`. Review your application for unexpected errors and ensure that `fa-icon` component always has a meaningful `icon` input.

When using `AsyncPipe` with `icon` input you have 3 options:

- Do not render `fa-icon` component until icon is loaded

    ```html
    <fa-icon *ngIf="icon$ | async as icon" [icon]="icon"></fa-icon>
    ```

- Render a placeholder icon while icon is loaded

    ```typescript
    // loadIcon() is your custom function to load icon definition asynchronously.
    loadIcon() {
      return of(faUser);
    }
  
    // Use `startsWith()` from RxJS to provide placeholder icon.
    this.icon$ = this.loadIcon().pipe(startsWith(defaultIcon));
    ```

- Provide a fallback icon to be used instead of any missing icon in the application

    ```typescript
    import { FaConfig } from '@fortawesome/angular-fontawesome';
    import { faBan } from '@fortawesome/free-solid-svg-icons';
  
    export class AppModule {
      constructor(config: FaConfig) {
        config.fallbackIcon = faBan;
      }
    } 
    ``` 

## Icon definition missing from the icon library is now hard error

Previously attempt to render an icon, which is missing from the icon library was logging a soft warning. In this release the warning was changed to a hard error to improve discoverability of such bugs. Review your application for unexpected errors and ensure that all used icons are added to the icon library.

Also refer to the [testing documentation](https://github.com/FortAwesome/angular-fontawesome/blob/master/docs/guide/testing.md#test-components-using-icon-library) to learn how to test components using icon library without getting missing icon errors.
