# Upgrading 0.4.0 to 0.5.0

## Migrate from global icon library to FaIconLibrary

Icon library from `@fortawesome/fontawesome-svg-core` (referred as *global icon library*) is deprecated in favour of `FaIconLibrary` provided by `@fortawesome/angular-fontawesome` and managed by Angular (referred as *icon library*).

The library will emit a warning when icon definition from a global icon library is used, so to migrate you'll need to replace all usages of the global icon library.

```diff
import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
-import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
-import { library } from '@fortawesome/fontawesome-svg-core';
+import { FontAwesomeModule, FaIconLibrary } from '@fortawesome/angular-fontawesome';
import { faCoffee, fas } from '@fortawesome/free-solid-svg-icons';
import { AppComponent } from './app.component';

@NgModule({
  declarations: [AppComponent],
  imports: [BrowserModule, FontAwesomeModule],
  bootstrap: [AppComponent]
})
export class AppModule {
-  constructor() {
+  constructor(library: FaIconLibrary) {
-   library.add(fas, faCoffee);
+   library.addIconPacks(fas);
+   library.addIcons(faCoffee);
  }
}
```

You can also use `FaConfig.globalLibrary` property to change the warning into the hard error or suppress warnings altogether (not recommended).

Note 1: `@fortawesome/fontawesome-svg-core` package is still used internally by the components, so you should not remove it from the dependencies and should use version 1.2.21 or newer as it is required by the peer dependency of `@fortawesome/angular-fontawesome` package.

Note 2: `FaIconLibrary` is only used by components provided by `angular-fontawesome` and won't work for `dom.watch()`. To make it work you'll need to register icons in both libraries. We actually don't recommend using `angular-fontawesome` together with `dom.watch()` and thinking to deprecated it. If you currently utilize it, please, drop by into https://github.com/FortAwesome/angular-fontawesome/issues/171 and share your use case.

## Changed semantics of FaIconComponent.icon property

`FaIconComponent.icon` property used to have type `Icon` (rendered icon object), which was changed to `IconProp` as it is now an input property to specify the icon definition. No replacement is provided.

If you were working with `FaIconComponent` programmatically you should switch from setting `FaIconComponent.iconProp` to `FaIconComponent.icon` as former is deprecated.  

## FaIconComponent.listItem is deprecated

The input was not working and we don't want to support this pattern in angular-fontawesome.

You can use `fixedWidth=true` and custom CSS to achieve similar behavior:

```css
ul {
  list-style-type: none;
  padding-left: 20px;
}
```

Demo: https://stackblitz.com/edit/angular-z8v4ux-o2yduf
