# Upgrading 0.14.0 to 0.15.0

## Remove usage of the `spin` and `pulse` inputs

Previously deprecated `spin` and `pulse` inputs in all components were removed. The usage should be replaced with a generic `animation` input which supports more animations. See [Animating icons](https://fontawesome.com/docs/web/style/animate) for a reference.

Dynamic animation can be achieved by binding the `animation` input to `undefined`:

```diff
- <fa-icon [icon]="['fas', 'sync']" [spin]="isSyncAnimated" (click)="isSyncAnimated=!isSyncAnimated"></fa-icon>
+ <fa-icon [icon]="['fas', 'sync']" [animation]="isSyncAnimated ? 'spin' : undefined" (click)="isSyncAnimated=!isSyncAnimated"></fa-icon>
```

## Remove usage of the `styles` and `classes` inputs

Previously deprecated `styles` and `classes` inputs in all components were removed. These inputs don't work the way one would expect and cause a lot of confusion. For the majority of the cases, one should use regular [class and style bindings](https://angular.io/guide/class-binding) provided by Angular. For those rare cases, when it is not enough, there is a guide on how one can style component's internal elements at their own risk - [Styling icon internals](https://github.com/FortAwesome/angular-fontawesome/blob/master/docs/guide/styling-icon-internals.md).

## Styles are correctly added in the SSR context

Previously, the library didn't correctly add global styles in the SSR context. If you have added global styles to your application to work around issues like [#407](https://github.com/FortAwesome/angular-fontawesome/issues/407), [#18](https://github.com/FortAwesome/angular-fontawesome/issues/18) or [#48](https://github.com/FortAwesome/angular-fontawesome/issues/48), you can either remove the workaround or alternatively, disable automatic styles injection by setting `FaConfig.autoAddCss` to `false`:

```typescript
import { FaConfig } from '@fortawesome/angular-fontawesome';

export class AppComponent {
  constructor(faConfig: FaConfig) {
    faConfig.autoAddCss = false;
  }
}
```

Not doing this should not cause any issues, but it will lead to same styles being added twice to the page.

## @fortawesome/fontawesome-svg-core became a regular dependency

Previously, `@fortawesome/fontawesome-svg-core` was a peer dependency. Now it is a regular dependency. This means that you don't have to add it to your `package.json` file anymore. Unless you use it directly for [advanced cases](https://github.com/FortAwesome/angular-fontawesome/blob/main/docs/guide/advanced-uses.md), you can remove the dependency:

```bash
$ npm uninstall @fortawesome/fontawesome-svg-core
```

And import types from `@fortawesome/angular-fontawesome` instead of `@fortawesome/fontawesome-svg-core`, e.g:

```diff
-import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
+import { IconDefinition } from '@fortawesome/angular-fontawesome';
```

## Icon inputs are now more permissive

Previously, `icon` input had a very restrictive type, which only allowed to specify icon pack and icon name values which exist in the Font Awesome icon packages. Now, the type is more permissive and allows to specify any string while retaining code completion for potentially available Font Awesome icon packs and icon names.

No changes are needed in the code, but consumers should be aware that the `<fa-icon>` component will no longer fail compilation if the icon name is not one of the Font Awesome icons, thus allowing to use [custom icons](../guide/custom-icons.md).

Refer to https://github.com/FortAwesome/angular-fontawesome/pull/436 for more details on the change.
