This is the repository for the _official_ Font Awesome Angular component, _initialized_ by the team behind Font Awesome, but intended to evolve over time with _community_ contributions.

# Ways to Contribute

## Ask a Question

Trying to figure out how to make it work? Or how to use it in your scenario?

1. Review the [README](README.md)
2. Get familiar with the documentation for the [SVG with JavaScript](https://fontawesome.com/how-to-use/svg-with-js) implementation, the framework upon which this component is built. Sometimes the answers you need may be there.
3. Post any remaining questions on [StackOverflow](https://stackoverflow.com/questions/tagged/angular-fontawesome) with the tag `angular-fontawesome`.

## Report a Bug

1. Create a test case that reproduces the unexpected behavior using [this StackBlitz template](https://stackblitz.com/edit/angular-ivy-9mvggg)
2. [Open a new issue with this template](https://github.com/FortAwesome/angular-fontawesome/issues/new?template=bug-report.md), and be sure to include a link to the reproduction you made with StackBlitz.

## Submit a Pull Request

Add tests if you add code.

## Everything Else

- [Request a feature](https://github.com/FortAwesome/angular-fontawesome/issues/new??title=Feature%20request:feature-name&template=feature-request.md)
- [Request a new icon](https://github.com/FortAwesome/Font-Awesome/issues/new?title=Icon%20request:%20icon-name&template=icon-request.md)

# Project Goals

1. Achieve and maintain feature parity with Font Awesome's [SVG with JavaScript](https://fontawesome.com/how-to-use/svg-with-js) method.

2. Keep with best practices in the Angular development community.

3. Stay current with major developments in Angular and Angular-CLI

4. Maintain a reasonable level of consistency between this component and the other Font Awesome official JavaScript framework components ([Vue](https://github.com/FortAwesome/vue-fontawesome), [React](https://github.com/FortAwesome/react-fontawesome), [Ember](https://github.com/FortAwesome/ember-fontawesome))

5. Sharing responsibility: The Font Awesome team will continue to be involved in ongoing development, hoping to _propel_ the project's momentum as we make _our_ contributions, while minimizing any bottle-necking that may happen as we balance our own priorities across various projects. Ideally, members of the community will enjoy lending a hand to help keep the project moving forward by responding to issues, answering questions on StackOverflow, reviewing and merging pull requests, and publishing npm updates.

# Code of Conduct

We'll contribute according to the [Code of Conduct](CODE_OF_CONDUCT.md).

# Wanted: Core Contributors

We're seeking core contributors to help drive this project. Core contributors:

1. Share these goals
2. Demonstrate competence through contributions
3. Contribute with conduct fitting with our code of conduct
4. Want to make this project awesome
