
# Alchemy

Alchemy is an open source, batteries included data engine, it provides a GraphQL API for your ArangoDB database with support for authentication, webhooks, events, remote schemas among other features. It is written in Rust with performance and reliability in mind and to be enterprise ready.

## Features
- Designed for Kubernetes and scalability
- Multi protocol CRUD for your database automatically
	- GraphQL
	- REST
	- gRPC
- Realtime updates (via GraphQL Subscriptions)
- First class support for Files via S3 and B2
- GIS capabilities for Maps & Navigation
	- Supports GeoJSON and GeoSpatial Queries
- Full text search (via ArangoSearch)
- Role based Authorization
- Eventing system (Actions & Triggers)
- Admin Console
- CLI
- Remote (GraphQL) Schemas
- Metadata APIs
- Schema Migrations
- Caching (frequent queries)
- Read-only replicas
- API limiting
- Collaborators (& roles)
- Single Sign On
- Alerting
- APM & Monitoring
- Backup and restore

and more planned / in the works.

## Community

Get involved with Alchemy and our community on our matrix server:

[![Matrix Server](https://matrix.org/blog/wp-content/uploads/2015/01/logo1.png)](https://matrix.to/#/#alchemy:matrix.org)




