# Contributing to Alchemy

Thank you for taking the time to contribute to Alchemy, we are an open community that encourages open development of the project with full transparency. We encourage open discussions surrounding the project, and the worst that can happen is we will politely tell you to make a few changes. We appreciate the effort for your contributions towards Alchemy, and we want to make the process simple and seamless for you.

The following document will help you increase the chances of us addressing your contributions promptly and successfully.

Before proceeding, please review the LICENSE for the project and understand that your contribution will be made in line with it, publicly to everyone; if you wish to protect your privacy, you may use an alternative Github account to make contributions from or alternatively, contribute via one of our git mirror repositories.

### First time contributors

We appreciate first time contributors and we are happy to assist you in getting started. In case of questions, just reach out to us! You find all issues suitable for first time contributors [here](https://github.com/ForetagInc/Alchemy/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22). If you feel overwhelmed and/or in need of support, we encourage you to join us on [Matrix server](https://matrix.to/#/#alchemy:matrix.org) where you can ask us questions directly.

## 1. Code of Conduct
Please follow our [Code of Conduct](https://github.com/ForetagInc/Alchemy/blob/dev/.github/code_of_conduct.md) in the context of any contributions made to Alchemy.

## 2. Repository structure
The Alchemy project, located on [ForetagInc/Alchemy](https://github.com/ForetagInc/Alchemy) is a mono-repository consisting of many components:

[1. Engine (Rust)](https://github.com/ForetagInc/Alchemy/tree/dev/engine)

[2. Console (TypeScript)](https://github.com/ForetagInc/Alchemy/tree/dev/console)

[3. CLI (Rust)](https://github.com/ForetagInc/Alchemy/tree/dev/cli)

## 3. Areas for Contributing

We welcome contributions across all the components of Alchemy, however if you are just getting started or would like to help us on priority issues here are particular areas to look into.

### Documentations

One of the project goals is to keep our documentation up to date and comprehensive, if this interests you could help with the following:

- Add to the documentation (features, bugs, limitations, workarounds)
- Fix any errors in the existing docs
- Report any missing content

### Community

Community content is designed to help users get started with Alchemy, you may wish to contribute to the following:

- Create tutorials on how to use Alchemy
- Fix errors on existing tutorials

Alternatively, you could work on the following projects:

- [Boilerplates](https://github.com/ForetagInc/Alchemy/tree/master/community/boilerplates)
- [Sample Apps](https://github.com/ForetagInc/Alchemy/tree/master/community/sample-apps)
- [Tools](https://github.com/ForetagInc/Alchemy/tree/master/community/tools)

## 4. Commit messages

At Foretag, we use [conventional commits](https://www.conventionalcommits.org/) across all of our projects for standardization. For examples see this [link](https://www.conventionalcommits.org/en/v1.0.0/#examples).

- The first line should be a summary of the changes, not exceeding 50 characters, followed by an optional body which has more details about the changes. Refer to this [link](https://github.com/erlang/otp/wiki/writing-good-commit-messages) for more information on writing good commit messages.

- Use the imperative present tense: "add/fix/change", not "added/fixed/changed" nor "adds/fixes/changes".

- Don't add a period/dot (.) at the end of the summary line.

