using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using SalesWebMvc.Data;
using System.Configuration;
using SalesWebMvc.Models;
using SalesWebMvc.Services;
using System.Globalization;
using Microsoft.AspNetCore.Localization;

var builder = WebApplication.CreateBuilder(args);
builder.Services.AddDbContext<SalesWebMvcContext>(options =>
    options.UseMySql(builder.Configuration.GetConnectionString("SalesWebMvcContext"),
    ServerVersion.AutoDetect(builder.Configuration.GetConnectionString("SalesWebMvcContext")),
    builder => builder.MigrationsAssembly("SalesWebMvc")));

builder.Services.AddScoped<SeedingService>();
builder.Services.AddScoped<SellerService>();
builder.Services.AddScoped<DepartamentService>();
builder.Services.AddScoped<SalesRecordService>();
builder.Services.AddScoped<NotesService>();

// Add services to the container.
builder.Services.AddControllersWithViews();

var app = builder.Build();
var enUS = new CultureInfo("en-US");
var localizationOption = new RequestLocalizationOptions()
{
    DefaultRequestCulture = new RequestCulture(enUS),
    SupportedCultures = new List<CultureInfo> { enUS },
    SupportedUICultures = new List<CultureInfo> { enUS },
};

app.UseRequestLocalization(localizationOption);

// The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
app.UseHsts();


app.UseHttpsRedirection();
app.UseStaticFiles();

app.UseRouting();

app.UseAuthorization();

// Injetando o SeedingService no pipeline de solicitao
// Aqui ns estamos dizendo para o aplicativo executar um pedao de cdigo somente se uma certa condio for verdadeira.
app.MapWhen(context =>
{
    // Aqui, estamos verificando em qual ambiente o aplicativo est rodando, se  "desenvolvimento" ou no.
    var env = context.RequestServices.GetRequiredService<IWebHostEnvironment>();

    // Se o aplicativo estiver em ambiente de "desenvolvimento"...
    if (env.IsDevelopment())
    { 
        // Aqui, estamos dizendo para o aplicativo pegar um servio que semeia dados e chamar um mtodo nele chamado "Seed".
        var seedingService = context.RequestServices.GetRequiredService<SeedingService>();
        seedingService.Seed();
    }

    // Aqui estamos dizendo que, independentemente de estar em ambiente de desenvolvimento ou no,
    // no vamos interromper o fluxo normal do aplicativo, ento estamos retornando "false".
    return false;
}, app => { });
  
app.MapControllerRoute(
    name: "default",
    pattern: "{controller=Home}/{action=Index}/{id?}");

app.Run();
