
# Sistema de Acompanhamento de Vendas (SalesWebMvc)

Este é um projeto desenvolvido durante o curso de C# avançado apresentado pelo professor Nelio Alves. Trata-se de uma plataforma de acompanhamento de vendas utilizando ASP.NET Core e SQL, onde foram aplicados diversos conceitos como Programação Orientada a Objetos (POO), CRUD, Injeção de Dependência, Expressões Lambda, entre outras ferramentas.

## Funcionalidades Principais

- Cadastro, edição e exclusão de pedidos.
- Cadastro, edição e exclusão de clientes.
- Cadastro, edição e exclusão de produtos.
- Cadastro, edição e exclusão de departamentos.
- Associação de clientes e produtos aos pedidos.
- Visualização de relatórios de vendas por departamento.

## Tecnologias Utilizadas

- ASP.NET Core
- Entity Framework Core (ORM)
- Banco de Dados SQL Server
- Razor Pages (para a construção das views)
- Bootstrap (para o design responsivo)
- C# (linguagem de programação)
- HTML, CSS e JavaScript (para a construção das interfaces)

## Como Usar

1. **Pré-requisitos**:
   - Visual Studio ou Visual Studio Code instalado
   - .NET Core SDK instalado
   - SQL Server instalado ou um serviço de banco de dados compatível

2. **Clonar o Repositório**:
   git clone https://github.com/Foqsz/SistemaWeb-ASP-NET-Core-MVC-EntityFramework

3. **Configurar o Banco de Dados**:
   - Crie um banco de dados SQL Server
   - Atualize a string de conexão no arquivo `appsettings.json` com as credenciais do seu banco de dados.

4. **Executar o Projeto**:
   - Abra a solução no Visual Studio ou Visual Studio Code
   - Build e execute o projeto

5. **Explorar o Sistema**:
   - Acesse o sistema no navegador através da URL `http://localhost:porta`

## Contribuindo

Contribuições são bem-vindas! Se você encontrar um bug, tiver uma ideia para uma nova funcionalidade ou quiser melhorar o código, sinta-se à vontade para abrir uma issue ou enviar um pull request.

## Contato

- **Email:** contatovictorvinicius05@gmail.com
- **LinkedIn:** [Victor Vinicius](https://www.linkedin.com/in/victor-vinicius-2a9166255/)

## Licença

Este projeto está licenciado sob a [Licença MIT](LICENSE).

---
© [Victor Vinicius Alves de Lima Souza] - [2024]
