import { Knex } from "knex";

export async function up(knex: Knex): Promise<void> {
  return knex.schema.createTable(`communities`, (table) => {
    table.increments(`id`).primary();
    table.text(`title`).notNullable().unique();
    table.text(`callsign`).notNullable().unique();
    table.text(`description`).notNullable();
    table.timestamp(`createdAt`).notNullable().defaultTo(knex.fn.now());
    table.timestamp(`updatedAt`).notNullable().defaultTo(knex.fn.now());
  });
}

export async function down(knex: Knex): Promise<void> {
  return knex.schema.dropTable(`communities`);
}
