﻿using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Stardrop.Models.SMAPI.Converters
{
    internal class BooleanConverterAssumeTrue : JsonConverter<bool>
    {
        public override bool Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            if (reader.TokenType == JsonTokenType.True || reader.TokenType == JsonTokenType.False)
            {
                return reader.GetBoolean();
            }

            string value = reader.GetString();
            if (Boolean.TryParse(value, out bool result))
            {
                return result;
            }

            return true;
        }

        public override void Write(Utf8JsonWriter writer, bool value, JsonSerializerOptions options)
        {
            throw new InvalidOperationException("This converter should not be used to write, it is read only.");
        }
    }
}
