import { Directive, ElementRef, Input, OnInit, inject } from '@angular/core';

/**
 * Directive is responsible to update the content of the heading with the value generated by client-side,
 * if it wasn't generated on server-side.
 */
@Directive({
  selector: '[appUpdateContentIfNotGeneratedByServer]',
  standalone: true
})
export class UpdateContentIfNotGeneratedByServerDirective implements OnInit {
  private readonly heading: ElementRef<HTMLHeadingElement> = inject(ElementRef);

  @Input({required: true}) clientContent!: string;

  ngOnInit(): void {
    if (!this.heading.nativeElement.innerHTML) {
      this.heading.nativeElement.innerHTML = this.clientContent;
    }
  }
}
