# Fincept Investments ✨

[![License: MIT](https://img.shields.io/badge/license-MIT-C06524)](https://github.com/yourusername/fincept-investments/blob/main/LICENSE.txt)
[![PyPI - Version](https://img.shields.io/pypi/v/fincept-investments.svg)](https://pypi.org/project/fincept-investments/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/fincept-investments.svg)](https://pypi.org/project/fincept-investments/)
[![Downloads](https://static.pepy.tech/badge/fincept-investments/month)](https://pypi.org/project/fincept-investments/)

**Fincept Investments** is a comprehensive CLI tool that provides financial insights, market analysis, and a host of other financial services such as technical analysis, fundamental analysis, sentiment analysis, quantitative analysis, and economic data services. It's designed to help investors and financial professionals navigate the complex world of investments with ease and precision.

(We are extending our data feeds everyday so check for new data on every alternate day and you can open an feature request on github if you want to add any custom data feed. If you are from another country and can help me with the data source of your country, please reach out to me.)

[![Watch the video](https://img.youtube.com/vi/7vf4ZOfDUTs/0.jpg)](https://www.youtube.com/watch?v=7vf4ZOfDUTs)

## Features 🧐

- **Dynamic Asset Searching**: we have an comprehensive list of assets from around the world
- **Economics**: Get economic indicators and analysis (Feature under development).
- **Global News**: Stay updated with top financial news across the globe.
- **Technical Analysis**: Perform technical analysis on stocks and market indices.
- **Fundamental Analysis**: Dive deep into the fundamentals of companies.
- **Sentiment Analysis**: Gauge market sentiment with real-time data.
- **Portfolio Management**: Create and Manage Custom made portfolios within your local machine.
- **Quantitative Analysis**: Analyze financial data using quantitative methods.
- **Economic Data**: Access key economic indicators to inform your investment decisions.
- **Robo Advisor**: Auto Generate Portfolios with the help of robo advisor.
- **BackTesting**: Easily Backtest your strategy or portfolios on our terminal with some keyword inputs.
- **Scanner**: Find the Breakout Stocks in realtime with using our Scanner feature which provides you best results on current market.
- **GenAI**: Get Customize recommendation on stocks or portfolio through GenAI one of the first Financial Terminal with AI Implemented in it.

## Installation 🚀

Install the latest version of Fincept Investments from PyPI: pip install fincept-investments 

Get the Windows Installation on this - https://github.com/Fincept-Corporation/FinceptTerminal/releases/download/Production0.1.2/FinceptInvestmentsInstaller.exe

## USAGE

```toml
fincept start
```

```toml
fincept --help
```

```toml
fincept --version
```

## UPCOMING FEATURS

- **World Mariane Trade Data**
- **Quant Analysis on Stocks**
- **Data Feed Update**
- **Company Finaical Statements Data**
- **Customize Terminal**
- **AirTraffic Data**
- **Country Specific Data**
- **Advance Technical/Fundamental Analysis**

## Star History

**PLEASE STAR ⭐ THE REPO AND SHARE THE PROJECT ❤️‍🩹 **

[![Star History Chart](https://api.star-history.com/svg?repos=Fincept-Corporation/fincept-investments&type=Date)](https://star-history.com/#Fincept-Corporation/fincept-investments&Date)

## FOR ANY QUERY OR UPDATE REACH OUT TO ME ON dev@fincept.in
