# [🚧 Flowbite Svelte Admin Dashboard 🚧 ](https://flowbite-admin-dashboard.vercel.app) [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/intent/tweet?url=https%3A%2F%2Fgithub.com%2Fthemesberg%2Fflowbite-svelte-admin-dashboard&text=Check%20out%20this%20open-source%20admin%20dashboard%20built%20with%20Flowbite%20and%20Tailwind%20CSS)

[![version](https://img.shields.io/npm/v/flowbite-svelte-admin-dashboard)](https://www.npmjs.com/package/flowbite-svelte-admin-dashboard)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE.md)
[![GitHub issues open](https://img.shields.io/github/issues/themesberg/flowbite-svelte-admin-dashboard.svg)](https://github.com/themesberg/flowbite-svelte-admin-dashboard/issues?q=is%3Aopen+is%3Aissue)
[![GitHub issues closed](https://img.shields.io/github/issues-closed-raw/themesberg/flowbite-svelte-admin-dashboard.svg)](https://github.com/themesberg/flowbite-svelte-admin-dashboard/issues?q=is%3Aissue+is%3Aclosed)

[![Flowbite Admin Dashboard Live Preview](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/flowbite-admin-dashboard-preview.png)](https://flowbite-admin-dashboard.vercel.app/)

This project is a free and open-source UI admin dashboard template built with the components from [Flowbite](https://github.com/themesberg/flowbite) and based on the utility-first [Tailwind CSS](https://github.com/tailwindlabs/tailwindcss) framework featuring charts, tables, widgets, CRUD layouts, modals, drawers, and more.

This admin dashboard can quickly help you get started building an application for your project using the newest UI/UX development technologies in the open-source area including Tailwind CSS and Flowbite.

## 🌀 Built with Flowbite

The interactive components such as the navbars, modals, drawers, and tooltips are all based on the popular [open-source component library called Flowbite](https://flowbite.com/) which enables us to use these elements by creating more complex set of pages and widgets inside a fully-fledged admin dashboard template.

## 💨 Tailwind CSS utility classes

All of the pages, widgets, and components are solely based on the utility-first classes from Tailwind CSS and it is compatible with the latest `v3.x` of the technology by automatically purging all of the classes based on the template paths.

## 📚 Flowbite documentation

If you want to use this project we recommend to also [study the component library](https://flowbite.com/docs/getting-started/introduction/) that we used to build this dashboard because you can use even more components from that library to enhance the examples that we've coded here already.

## Table of Contents

- [Flowbite Admin Dashboard ](#flowbite-admin-dashboard-)
  - [🌀 Built with Flowbite](#-built-with-flowbite)
  - [💨 Tailwind CSS utility classes](#-tailwind-css-utility-classes)
  - [📚 Flowbite documentation](#-flowbite-documentation)
  - [Table of Contents](#table-of-contents)
  - [Demo pages](#demo-pages)
  - [Quick start](#quick-start)
  - [Browser Support](#browser-support)
  - [Resources](#resources)
  - [Reporting Issues](#reporting-issues)
  - [Technical Support or Questions](#technical-support-or-questions)
  - [Licensing](#licensing)
  - [Useful Links](#useful-links)
  - [Authors](#authors)

## Demo pages

| 🚧 Dashboard                                                                                               | 🚧 Stacked Layout                                                                                              | 🚧 Products (CRUD)                                                                                                    |
| ---------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| [![Dashboard](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/homepage.jpg)]() | [![Stacked Layout](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/stacked.jpg)]() | [![Products (CRUD)](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/products-crud.jpg)]() |

| 🚧 Users (CRUD)                                                                                            | 🚧 Settings                                                                                               | 🚧 Pricing page                                                                                              |
| ---------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------ |
| [![Users (CRUD)](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/users.jpg)]() | [![Settings](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/settings.jpg)]() | [![Pricing page](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/pricing.jpg)]() |

| Login page                                                                                                                                                                         | Register page                                                                                                                                                                            | Reset password                                                                                                                                                                                        |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Login page](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/login.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/authentication/sign-in/) | [![Register page](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/register.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/authentication/sign-up/) | [![Reset password](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/reset-password.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/authentication/reset-password) |

| Forgot password                                                                                                                                                                                          | Profile lock                                                                                                                                                                                    | Maintenance page                                                                                                                                                                         |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Forgot password](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/forgot-password.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/authentication/forgot-password) | [![Profile lock](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/profile-lock.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/authentication/profile-lock) | [![Maintenance page](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/maintenance.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/pages/maintenance) |

| 404 not found                                                                                                                                                         | 500 server error                                                                                                                                                         | 🚧 Playground                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------- |
| [![404 not found](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/404.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/pages/404) | [![500 server error](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/500.jpg)](https://flowbite-svelte-admin-dashboard.vercel.app/pages/500) | [![Playground](https://flowbite.s3.amazonaws.com/templates/flowbite-admin-dashboard/github/playground.jpg)]() |

- [Live Preview](https://flowbite-svelte-admin-dashboard.vercel.app/)

## Quick start

1. [Install Flowbite-Svelte](https://flowbite-svelte.com/docs/pages/introduction)

2. Install flowbite-svelte-admin-dashboard

```bash
pnpm i flowbite-svelte-admin-dashboard
```

## Browser Support

At present, we officially aim to support the last two versions of the following browsers:

<img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/chrome.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/firefox.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/edge.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/safari.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/opera.png" width="64" height="64">

## Resources

- Live preview: <https://flowbite-svelte-admin-dashboard.vercel.app/>
- Flowbite documentation: <https://flowbite.com/docs/getting-started/introduction/>
- Tailwind CSS documentation: <https://tailwindcss.com/>
- License Agreement: <https://flowbite.com/docs/getting-started/license/>
- Issues: [Github Issues Page](https://github.com/themesberg/flowbite-svelte-admin-dashboard/issues)

## Reporting Issues

We use GitHub Issues as the official bug tracker for Flowbite Svelte Admin Dashboard. Here are some advices for our users that want to report an issue:

1. Make sure that you are using the latest version of Flowbite Admin Dashboard. Check the CHANGELOG from your dashboard on the [GitHub releases page](https://github.com/themesberg/flowbite-svelte-admin-dashboard/releases).
2. Providing us reproducible steps for the issue will shorten the time it takes for it to be fixed.
3. Some issues may be browser specific, so specifying in what browser you encountered the issue might help.

## Technical Support or Questions

If you have questions or need help integrating the product please [contact us](https://github.com/themesberg/flowbite-svelte-admin-dashboard/issues) instead of opening an issue.

## Licensing

- Copyright 2019-2023 Bergside Inc. (https://flowbite.com)
- Open-source under the [MIT License](https://github.com/themesberg/flowbite-admin-dashboard/blob/main/LICENSE)

## Useful Links

- 🌶 [Flowbite-Svelte](https://flowbite-svelte.com) - Open-source components for Svelte
- 📚 [Flowbite Library](https://flowbite.com/) - Open-source components built with Tailwind CSS
- 🎨 [Flowbite Figma](https://flowbite.com/figma/) - Design system built for Figma
- 🧱 [Flowbite Svelte Blocks](https://flowbite-svelte-blocks.com/blocks/) - Building sections for website and applications
- 💎 [Flowbite Pro](https://flowbite.com/pro/) - A larger collection of the open-source version of the latter three

## Authors

- [Zoltán Szőgyényi](https://twitter.com/zoltanszogyenyi)
- [Robert Tanislav](https://twitter.com/roberttanislav)
- [Shinichi Okada](https://twitter.com/shinokada)
