# :book: [U&I with React (book)](https://leanpub.com/ui-react)

On building modular, extendable and scalable **U**&**I** — UI intended for all developers, like **you** and **I**.

Copyright © 2017 [Farhad Ghayour](https://twitter.com/farhadg_com)

<a target="_blank" href="https://leanpub.com/ui-react">
  <img width="350" src="manuscript/images/book-cover-preview.jpg" alt="U&I with React Book" />
</a>

[Leanpub](https://leanpub.com/ui-react)

[![License: CC BY-NC-SA 4.0](https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-blue.svg)](LICENSE)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](CONTRIBUTIONS.md)

Please feel free to contribute to the quality of this content by submitting PRs for improvements to code snippets, explanations, etc.

## About
Frontend development has undergone a major transformation with modern frontend technologies, such as React, Angular, Vue, and so forth. This is largely due to the wide adoption of component-based architecture provided by these wildly successful technologies.

This book aims to not only guide readers from the foundational building blocks of creating well structured interfaces but also provide an exhaustive list of different philosophies for creating modular, extendable and scalable **U**&**I** --- i.e. UI intended for all developers, like **you** and **I**.

## Topics
Even though the concepts in this book are taught via React, they are transferable to other frontend technologies. I chose React as our base because of simplicity, wide adoption, and undeniable power that it provides.

### [Chapter 1: Introduction](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter1.md)
Explains a brief history of web development and the rise of component-based architecture.

### [Chapter 2: What is U&I?](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter2.md)
Provides an in depth view of U&I and the criteria for building them.

### [Chapter 3: Getting Started](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter3.md)
Outlines some of the base technologies we'll be using and then walks us through setting up a boilerplate codebase.

### [Chapter 4: Building our App](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter4.md)
Guides us through building the foundation of our application.

### [Chapter 5: Using U&I Concepts](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter5.md)
Guides us on refactoring our application using U&I best practices.

### [Chapter 6: Exploring CSS Preprocessors](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter6.md)
Explains CSS preprocessors and guides us on refactoring our interface using Sass.

### [Chapter 7: Exploring CSS Modules](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter7.md)
Introduces CSS modules and guides us on refactoring our interface using CSS modules.

### [Chapter 8: Exploring Inline Styles](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter8.md)
Takes us on a journey through inline styles and guides us on refactoring our application using this dated philosophy in a modern setting.

### [Chapter 9: Adding Real Time Capabilities](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter9.md)
Introduces an entirely new perspective of looking at interactive interfaces and helps bring our application to life with real time capabilities.

### [Chapter 10: Showcasing](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter10.md)
Guides us on how we can build, document and showcase our components in an isolated environment.

### [Chapter 11: Looking Ahead](https://github.com/FarhadG/ui-react/blob/master/manuscript/chapter11.md)
Compares the various methodologies covered throughout this book, with a glimpse into the future of UI development.

## Audience
This book is ideal for developers who are familiar with React and are looking for a comprehensive guide for building modular, extendable and scalable user interfaces. Even though this book is intended for intermediate to advanced React developers, anyone new to React can easily follow along given the progressive format of this book where each chapter builds on the chapters before.

## Publishing
These books are being released here as drafts, free to read, but are also being edited, produced and published through [Leanpub](https://leanpub.com/ui-react).

## Contributions
Please review the [guidelines](CONTRIBUTIONS.md). Any contributions you make to this effort **are greatly appreciated**.
