'''
    This module has ready to use sqlite query functions.
'''

from datetime import datetime
import sqlite3

# connect to database
conn = sqlite3.connect('notes.db')

# create a cursor
c = conn.cursor()


def create_table():
    '''
        create notes table in database.
    '''

    c.execute(""" CREATE TABLE IF NOT EXISTS notes(
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title text,
            content text,
            dateAdded text
        )""")


def token_table():
    '''
        create token table in database.
    '''

    c.execute(""" CREATE TABLE IF NOT EXISTS Token(
            token text
        )""")


def drop_token():
    '''
        delete token from the table.
    '''

    with conn:
        c.execute(""" DROP TABLE IF EXISTS Token """)
        conn.commit()


def add_token(mytoken: str):
    '''
        adds token to table.
    '''

    drop_token()
    token_table()
    with conn:
        c.execute("INSERT INTO Token(token) VALUES(:token)",
                  {'token': mytoken})
        conn.commit()


def show_token():
    '''
        fetch token from the table.
    '''

    token_table()
    with conn:
        c.execute("SELECT token from Token")
        token = c.fetchone()
        if token is not None:
            for token in token:
                return token
        else:
            return None

def create_note(note_name: str, note_content: str):
    '''
        add new note.
    '''

    date = datetime.today().strftime('%d/%b/%H:%M')
    with conn:
        c.execute("INSERT INTO notes(title, content, dateAdded) VALUES( :title, :content, :dateAdded)",
                  {'title': note_name, 'content': note_content, 'dateAdded': date})
        conn.commit()


def get_note(new_name: str):
    '''
        access content from specific note.
    '''

    with conn:
        c.execute('''SELECT content from notes WHERE title LIKE ?''', (new_name,))
        rows = c.fetchone()
        for row in rows:
            return row


def edit_note_name(noteName: str, newName: str):
    '''
        edit note name.
    '''

    date = datetime.today().strftime('%d/%b/%H:%M')
    with conn:
        c.execute('''UPDATE notes SET title = ? WHERE title LIKE ? ''',
                  (newName, noteName,))
        conn.commit()
    with conn:
        c.execute(
            '''UPDATE notes SET dateAdded = ? WHERE title LIKE ? ''', (date, newName,))
        conn.commit()


def edit_note_content(noteName: str, newContent: str):
    '''
        edit note content.
    '''

    date = datetime.today().strftime('%d/%b/%H:%M')
    with conn:
        c.execute('''UPDATE notes SET content = ? WHERE title LIKE ? ''',
                  (newContent, noteName,))
        conn.commit()
    with conn:
        c.execute(
            '''UPDATE notes SET dateAdded = ? WHERE title LIKE ? ''', (date, noteName,))
        conn.commit()


def delete_note(noteName: str):
    '''
        delete note.
    '''

    with conn:
        c.execute('''DELETE FROM notes WHERE title LIKE ? ''', (noteName,))
        conn.commit()


def get_all_notes():
    '''
    fetch all notes from table & add to dictionary.
    '''

    with conn:
        conn.row_factory = sqlite3.Row
        curs = conn.cursor()
        curs.execute("SELECT * FROM notes")
        rows = curs.fetchall()
        Dict = []
        for row in rows:
            Dict.append(dict(row))
        return Dict


create_table()
token_table()