unit DelphiAST.Consts;

interface

type
  TSyntaxNodeType = (
    ntUnknown,
    ntAdd,
    ntAddr,
    ntAlignmentParam,
    ntAnd,
    ntAnonymousMethod,
    ntArguments,
    ntAs,
    ntAssign,
    ntAt,
    ntAttribute,
    ntAttributes,
    ntBounds,
    ntCall,
    ntCase,
    ntCaseElse,
    ntCaseLabel,
    ntCaseLabels,
    ntCaseSelector,
    ntClassConstraint,
    ntConstant,
    ntConstants,
    ntConstraints,
    ntConstructorConstraint,
    ntContains,
    ntDefault,
    ntDeref,
    ntDimension,
    ntDiv,
    ntDot,
    ntDownTo,
    ntElement,
    ntElse,
    ntEmptyStatement,
    ntEnum,
    ntEqual,
    ntExcept,
    ntExceptionHandler,
    ntExports,
    ntExpression,
    ntExpressions,
    ntFDiv,
    ntField,
    ntFields,
    ntFinalization,
    ntFinally,
    ntFor,
    ntFrom,
    ntGeneric,
    ntGoto,
    ntGreater,
    ntGreaterEqual,
    ntGuid,
    ntHelper,
    ntIdentifier,
    ntIf,
    ntImplementation,
    ntImplements,
    ntIn,
    ntIndexed,
    ntInherited,
    ntInitialization,
    ntInterface,
    ntIs,
    ntLabel,
    ntLHS,
    ntLiteral,
    ntLower,
    ntLowerEqual,
    ntMessage,
    ntMethod,
    ntMod,
    ntMul,
    ntName,
    ntNamedArgument,
    ntNotEqual,
    ntNot,
    ntOr,
    ntPackage,
    ntParameter,
    ntParameters,
    ntPath,
    ntPositionalArgument,
    ntProtected,
    ntPrivate,
    ntProperty,
    ntPublic,
    ntPublished,
    ntRaise,
    ntRead,
    ntRecordConstraint,
    ntRepeat,
    ntRequires,
    ntReturnType,
    ntRHS,
    ntRoundClose,
    ntRoundOpen,
    ntSet,
    ntShl,
    ntShr,
    ntStatement,
    ntStatements,
    ntSub,
    ntSubrange,
    ntThen,
    ntTo,
    ntTry,
    ntType,
    ntTypeArgs,
    ntTypeDecl,
    ntTypeParam,
    ntTypeParams,
    ntTypeSection,
    ntValue,
    ntVariable,
    ntVariables,
    ntXor,
    ntUnaryMinus,
    ntUnit,
    ntUses,
    ntWhile,
    ntWith,
    ntWrite
  );

  TAttributeName = (
    anType,
    anClass,
    anForwarded,
    anKind,
    anName,
    anVisibility,
    anCallingConvention,
    anPath,
    anMethodBinding,
    anReintroduce,
    anOverload,
    anAbstract
  );

const
  SyntaxNodeNames: array [TSyntaxNodeType] of string = (
    'unknown',
    'add',
    'addr',
    'alignmentparam',
    'and',
    'anonymousmethod',
    'arguments',
    'as',
    'assign',
    'at',
    'attribute',
    'attributes',
    'bounds',
    'call',
    'case',
    'caseelse',
    'caselabel',
    'caselabels',
    'caseselector',
    'classconstraint',
    'constant',
    'constants',
    'constraints',
    'constructorconstraint',
    'contains',
    'default',
    'deref',
    'dimension',
    'div',
    'dot',
    'downto',
    'element',
    'else',
    'emptystatement',
    'enum',
    'equal',
    'except',
    'exceptionhandler',
    'exports',
    'expression',
    'expressions',
    'fdiv',
    'field',
    'fields',
    'finalization',
    'finally',
    'for',
    'from',
    'generic',
    'goto',
    'greater',
    'greaterequal',
    'guid',
    'helper',
    'identifier',
    'if',
    'implementation',
    'implements',
    'in',
    'indexed',
    'inherited',
    'initialization',
    'interface',
    'is',
    'label',
    'lhs',
    'literal',
    'lower',
    'lowerequal',
    'message',
    'method',
    'mod',
    'mul',
    'name',
    'namedargument',
    'notequal',
    'not',
    'or',
    'package',
    'parameter',
    'parameters',
    'path',
    'positionalargument',
    'protected',
    'private',
    'property',
    'public',
    'published',
    'raise',
    'read',
    'recordconstraint',
    'repeat',
    'requires',
    'returntype',
    'rhs',
    'roundclose',
    'roundopen',
    'set',
    'shl',
    'shr',
    'statement',
    'statements',
    'sub',
    'subrange',
    'then',
    'to',
    'try',
    'type',
    'typeargs',
    'typedecl',
    'typeparam',
    'typeparams',
    'typesection',
    'value',
    'variable',
    'variables',
    'xor',
    'unaryminus',
    'unit',
    'uses',
    'while',
    'with',
    'write'
  );

const
  sENUM              = 'enum';
  sSUBRANGE          = 'subrange';

  function AttributeNameToStr(const AttributeName : TAttributeName) : string;

implementation

function AttributeNameToStr(const AttributeName : TAttributeName) : string;
const
  AttributeNameStrings : array[TAttributeName] of string = (
    'type',
    'class',
    'forwarded',
    'kind',
    'name',
    'visibility',
    'callingconvention',
    'path',
    'methodbinding',
    'reintroduce',
    'overload',
    'abstract'
  );
begin
  Exit(AttributeNameStrings[AttributeName]);
end;

end.
