<?php
/**
 * Interface representing extended HTTP status codes for HTTP2. These codes
 * are represented as an interface so that developers may implement it and then
 * use parent::[CODE] to gain a code, or to extend the codes using
 * static::[CODE] and override their default description.
 *
 * This allows for codes to be repurposed in a natural way where the core,
 * traditional use would not be meaningful.
 *
 * PHP version 5.3
 *
 * @category StatusCode
 *
 * @package Teapot\StatusCode\RFC
 *
 * @author    Barney Hanlon <barney@shrikeh.net>
 * @copyright 2013-2016 B Hanlon. All rights reserved.
 * @license   MIT http://opensource.org/licenses/MIT
 *
 * @see https://github.com/teapot-php/status-code
 */

namespace Teapot\StatusCode\RFC;

use Teapot\StatusCode\RFC\Status\ProposedStandard;
use Teapot\StatusCode\RFC\Stream\IETF as IETFStream;

/**
 * Interface representing extended HTTP status codes for HTTP2. These codes
 * are represented as an interface so that developers may implement it and then
 * use parent::[CODE] to gain a code, or to extend the codes using
 * static::[CODE] and override their default description.
 *
 * This allows for codes to be repurposed in a natural way where the core,
 * traditional use would not be meaningful.
 *
 * PHP version 5.3
 *
 * @category StatusCode
 *
 * @package Teapot\StatusCode\RFC
 *
 * @author    Barney Hanlon <barney@shrikeh.net>
 * @copyright 2013-2016 B Hanlon. All rights reserved.
 * @license   MIT http://opensource.org/licenses/MIT
 *
 * @see https://github.com/teapot-php/status-code
 */
interface RFC7540 extends IETFStream, ProposedStandard
{
    /**
     * The 421 (Misdirected Request) status code indicates that the request was
     * directed at a server that is not able to produce a response. This can be
     * sent by a server that is not configured to produce responses for the
     * combination of scheme and authority that are included in the request URI.
     *
     * Clients receiving a 421 (Misdirected Request) response from a server MAY
     * retry the request — whether the request method is idempotent or not —
     * over a different connection. This is possible if a connection is reused
     * (Section 9.1.1) or if an alternative service is selected [ALT-SVC].
     *
     * This status code MUST NOT be generated by proxies.
     *
     * A 421 response is cacheable by default, i.e., unless otherwise indicated
     * by the method definition or explicit cache controls (see Section 4.2.2 of
     * [RFC7234]).
     *
     * @see https://datatracker.ietf.org/doc/html/rfc7540#section-9.1.2
     *
     * @var int
     */
    public const MISDIRECTED_REQUEST = 421;
}
