The SVG files in this folder are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/legalcode). 
They come from the [EmojiTwo project](https://github.com/EmojiTwo/emojitwo), which is a fork of a project called EmojiOne.
EmojiOne's original publisher also has a closed-source successor to EmojiOne called [Joypixels](https://github.com/joypixels).

I have modified several of these SVG files to work with Google's nanoemoji font builder.
[The changes I have made can be viewed here.](https://github.com/Emoji-COLRv0/emojitwo/commits/master)
None of these changes meaningfully alter the artistic content content of the files, and so all credit should still go to Joypixels and the EmojiTwo Project.

This font project is not officially affliated with either Joypixels nor the EmojiTwo project.

The original licensing information from the EmojiTwo project is reproduced below:

---

## Emojione 2.x Artwork License

*  Applies to all PNG and SVG files as well as any adaptations made.
    *  [License](LICENSE.md): Creative Commons Attribution 4.0 International
    *  Human Readable License: http://creativecommons.org/licenses/by/4.0/
    *  Complete Legal Terms: http://creativecommons.org/licenses/by/4.0/legalcode
  
### Emojione Artwork Attribution

With the release of version 3.0, the Emojione project also made changes to 2.2.7’s licensing. 
[Previously](https://web-beta.archive.org/web/20170327003706/http://emojione.com/licensing/#attribution), Emojione did not require attribution for non-commercial and personal use. Considering that the Emojione project only changed the documentation in that branch to mandate attribution in any case, Emojitwo forked a state before those changes for greater flexibility.

For **non-commercial** and **personal use**, you *should* credit the creators. 
For **commercial use**, proper attribution *must* be given on every web page, app, or video description where our emojis are displayed. 

### Creative Commons Requirements

In section 3(a)(1) of the CC-BY 4.0 legal terms, it lists the following as the guidelines needed to fulfill the attribution requirements:

> If You Share the Licensed Material (including in modified form), You must:
> - retain the following if it is supplied by the Licensor with the Licensed Material:
>     - identification of the creator(s) of the Licensed Material and any others designated to receive attribution, in any reasonable manner requested by the Licensor (including by pseudonym if designated);
>     - a copyright notice;
>     - a notice that refers to this Public License;
>     - a notice that refers to the disclaimer of warranties;
>     - a URI or hyperlink to the Licensed Material to the extent reasonably practicable;
> - indicate if You modified the Licensed Material and retain an indication of any previous modifications; and
> - indicate the Licensed Material is licensed under this Public License, and include the text of, or the URI or hyperlink to, this Public License."

### Proper Attribution Examples

Must contain:
- The original name _Emojione_ (or _Emoji One_) and the forked name _Emojitwo_ (or _Emoji Two_).
- Links to the repository and Ranks.com's website
    - https://github.com/EmojiTwo/emojitwo/ or https://emojitwo.github.io/emojitwo/
    - https://www.emojione.com
- The title and a link to the Creative Commons license
    - Creative Commons Attribution International 4.0 (CC-BY 4.0)
    - https://creativecommons.org/licenses/by/4.0/legalcode

Also helpful:
- Make sure it does not look like Ranks.com or the Emojitwo community created or endorsed your product.
- List all modifications you've made to the artwork. (Also consider to submit them for inclusion.)
- A reference to Ranks.com as original creators of Emojione.

### Ideal Attribution

> Emoji artwork is provided by [Emojitwo](https://emojitwo.github.io/), 
> originally released as [Emojione 2.2](https://www.emojione.com) by [Ranks.com](http://www.ranks.com)
> with contributions from the Emojitwo community
> and is licensed under [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/legalcode).

### Attribution Location

#### Apps
- A note with link in the *app store description* is required.
- Other links and praise are much appreciated:
    - app settings
    - official app website
    - social media
    
#### Websites
- A note with link on *every web page* where our emojis are displayed is required.
- Other links and praise are much appreciated:
    - main homepage
    - social media
    
#### Web Videos
- A note with link in the *video description* is required.
- Other links and praise are much appreciated:
    - on-screen when emojis are displayed
    - on-screen in credits
    - social media
