﻿using System;
using UELib.Core;

namespace UELib.Decompiler
{
    // Static non-interface visitor class because we don't require any polymorphism here.
    public static class IsCompilerAutoGeneratedHelper
    {
        public static bool Visit(UDelegateProperty obj)
        {
            return obj.Name.StartsWith("__", StringComparison.OrdinalIgnoreCase) &&
                   obj.Name.EndsWith("__Delegate", StringComparison.OrdinalIgnoreCase);
        }

        public static bool Visit(UField obj)
        {
            return false;
        }

        public static bool Visit(UObject obj)
        {
            return obj.Name.StartsWith("Default__", StringComparison.OrdinalIgnoreCase);
        }
    }
}
