# Generated by Django 4.2.11 on 2024-06-27 15:16

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.functions.text
import library_system.models
import library_system.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=40, validators=[library_system.validators.NameValidator()])),
                ('last_name', models.CharField(max_length=40, validators=[library_system.validators.NameValidator()])),
                ('slug', models.SlugField(max_length=100, unique=True)),
            ],
            bases=(models.Model, library_system.models.SlugMixin),
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('isbn', models.CharField(help_text='13 character ISBN number.', max_length=13, unique=True, validators=[library_system.validators.ISBNValidator()], verbose_name='ISBN')),
                ('title', models.CharField(max_length=100)),
                ('summary', models.TextField(help_text="A short summary of the book's story.")),
                ('pages', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(limit_value=1, message='Value must be positive.')])),
                ('edition', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(limit_value=1, message='Value must be positive.')])),
                ('publish_date', models.DateField(blank=True, null=True)),
                ('language', models.CharField(choices=[('en', 'English'), ('zh', 'Chinese'), ('de', 'German'), ('es', 'Spanish'), ('ja', 'Japanese'), ('ru', 'Russian'), ('ar', 'Arabic')], default='en', max_length=2)),
            ],
        ),
        migrations.CreateModel(
            name='BookInstance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('due_date', models.DateField(blank=True, help_text='Date that the borrower must return the book by. Defaults to 3 weeks after borrowing.', null=True)),
                ('status', models.CharField(blank=True, choices=[('M', 'Maintenance'), ('B', 'Borrowed'), ('R', 'Reserved'), ('A', 'Available')], default='M', max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40, validators=[library_system.validators.NameValidator()])),
                ('slug', models.SlugField(max_length=60, unique=True)),
            ],
            options={
                'verbose_name': 'category',
                'verbose_name_plural': 'categories',
            },
            bases=(models.Model, library_system.models.SlugMixin),
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stars', models.IntegerField(choices=[(1, 'One'), (2, 'Two'), (3, 'Three'), (4, 'Four'), (5, 'Five')])),
                ('review_text', models.TextField(help_text='Write your review here.')),
                ('book', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to='library_system.book')),
                ('reviewer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40)),
                ('slug', models.SlugField(max_length=60, unique=True)),
            ],
            options={
                'indexes': [models.Index(fields=['name'], name='publication_name_index')],
            },
        ),
        migrations.AddConstraint(
            model_name='publication',
            constraint=models.UniqueConstraint(django.db.models.functions.text.Lower('name'), name='publication_unique_name'),
        ),
        migrations.AddIndex(
            model_name='category',
            index=models.Index(fields=['name'], name='category_name_index'),
        ),
        migrations.AddConstraint(
            model_name='category',
            constraint=models.UniqueConstraint(django.db.models.functions.text.Lower('name'), name='category_unique_name'),
        ),
        migrations.AddField(
            model_name='bookinstance',
            name='book',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='book_copies', to='library_system.book'),
        ),
        migrations.AddField(
            model_name='bookinstance',
            name='borrower',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, related_name='borrowed_books', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='book',
            name='authors',
            field=models.ManyToManyField(related_name='books', to='library_system.author'),
        ),
        migrations.AddField(
            model_name='book',
            name='categories',
            field=models.ManyToManyField(related_name='books', to='library_system.category'),
        ),
        migrations.AddField(
            model_name='book',
            name='publication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='books', to='library_system.publication'),
        ),
        migrations.AddIndex(
            model_name='author',
            index=models.Index(fields=['first_name', 'last_name'], name='author_full_name_index'),
        ),
        migrations.AddConstraint(
            model_name='author',
            constraint=models.UniqueConstraint(django.db.models.functions.text.Lower('first_name'), django.db.models.functions.text.Lower('last_name'), name='author_unique_full_name'),
        ),
        migrations.AddIndex(
            model_name='review',
            index=models.Index(fields=['book', 'stars'], name='review_book_stars_index'),
        ),
        migrations.AddIndex(
            model_name='bookinstance',
            index=models.Index(fields=['due_date'], name='book_instance_due_date_index'),
        ),
        migrations.AddIndex(
            model_name='book',
            index=models.Index(fields=['language'], name='book_language_index'),
        ),
    ]
