function createSvg(d, options) {
  options = Object.assign({ fillColor: '#20A0FF', transform: '' }, options)
  return function(h) {
    return h(
      'svg',
      {
        attrs: {
          viewBox: '0 0 16 16'
        },
        style: {
          width: '16px',
          height: '16px'
        }
      },
      [
        h(
          'g',
          {
            attrs: {
              stroke: 'none',
              'stroke-width': '1',
              fill: 'none',
              'fill-rule': 'evenodd'
            }
          },
          [
            h(
              'g',
              {
                attrs: {
                  transform: options.transform,
                  fill: options.fillColor
                }
              },
              [
                h('path', {
                  attrs: {
                    d
                  },
                  style: {
                    transition: 'all .2s'
                  }
                })
              ]
            )
          ]
        )
      ]
    )
  }
}

export const full = createSvg(
  'M132,81.9962027 C132,79.7891609 133.78883,78 135.996203,78 L144.003797,78 C146.210839,78 148,79.7888304 148,81.9962027 L148,90.0037973 C148,92.2108391 146.21117,94 144.003797,94 L135.996203,94 C133.789161,94 132,92.2111696 132,90.0037973 L132,81.9962027 Z M137.698564,89.8954727 C137.928214,90.1318772 138.300826,90.1370767 138.541509,89.8963942 L145.089943,83.3479599 C145.403039,83.0348634 145.402466,82.5266599 145.087164,82.2113581 L144.969466,82.0936604 C144.654835,81.779029 144.147907,81.7758387 143.836075,82.0876707 L138.171522,87.7522235 L136.055486,85.6361881 C135.740937,85.3216388 135.231556,85.3210349 134.916254,85.6363368 L134.798556,85.7540345 C134.483925,86.0686658 134.483805,86.5861628 134.785566,86.8967982 L137.698564,89.8954727 Z',
  {
    fillColor: '#20A0FF',
    transform: 'translate(-132.000000, -78.000000)'
  }
)

export const empty = createSvg(
  'M99.3333333,90.0037973 C99.3333333,91.4746588 100.525409,92.6666667 101.996203,92.6666667 L110.003797,92.6666667 C111.474659,92.6666667 112.666667,91.4745907 112.666667,90.0037973 L112.666667,81.9962027 C112.666667,80.5253412 111.474591,79.3333333 110.003797,79.3333333 L101.996203,79.3333333 C100.525341,79.3333333 99.3333333,80.5254093 99.3333333,81.9962027 L99.3333333,90.0037973 Z M101.996203,78 L110.003797,78 C112.210839,78 114,79.7888304 114,81.9962027 L114,90.0037973 C114,92.2108391 112.21117,94 110.003797,94 L101.996203,94 C99.7891609,94 98,92.2111696 98,90.0037973 L98,81.9962027 C98,79.7891609 99.7888304,78 101.996203,78 Z',
  {
    fillColor: '#C0CCDA',
    transform: 'translate(-98.000000, -78.000000)'
  }
)

export const part = createSvg(
  'M48,81.9962027 C48,79.7891609 49.7888304,78 51.9962027,78 L60.0037973,78 C62.2108391,78 64,79.7888304 64,81.9962027 L64,90.0037973 C64,92.2108391 62.2111696,94 60.0037973,94 L51.9962027,94 C49.7891609,94 48,92.2111696 48,90.0037973 L48,81.9962027 Z M51.5030483,86.25 C51.5030483,85.5596441 52.0660386,85 52.7544598,85 L59.2516369,85 C59.9427723,85 60.5030483,85.554831 60.5030483,86.25 C60.5030483,86.9403559 59.940058,87.5 59.2516369,87.5 L52.7544598,87.5 C52.0633243,87.5 51.5030483,86.945169 51.5030483,86.25 Z',
  {
    fillColor: '#20A0FF',
    transform: 'translate(-48.000000, -78.000000)'
  }
)
