import 'package:flutter/material.dart';
import 'package:mq_app_theme/mq_app_theme.dart';

@immutable
final class ReadThemeRepositoryImpl implements ReadThemeRepository {
  const ReadThemeRepositoryImpl(this.localThemeDataSource);

  final LocalThemeDataSourceImpl localThemeDataSource;

  @override
  ReadThemeData getInitialThemeState() {
    return localThemeDataSource.getInitialThemeState();
  }

  @override
  Future<void> saveThemeState(ReadThemeData themeState) {
    return localThemeDataSource.saveThemeState(themeState);
  }
}
