# Contributing to MyQuran

Thank you for considering contributing to the MyQuran project! Your efforts help us bring the spiritual guidance of the Qur'an to a wider audience. To ensure a smooth collaboration, please follow these guidelines.

## How to Contribute

1. **Fork the Repository**

   - Start by forking the MyQuran repository to your GitHub account.

2. **Clone Your Fork**

   - Clone your forked repository to your local machine to make changes.

   ```bash
   git clone https://github.com/your-username/MyQuran.git
   cd MyQuran
   ```

3. **Fork the Repository**

   - Always create a new branch for each contribution. This keeps your work organized and makes it easier for others to review your code.

   ```bash
   git checkout -b feature/your-feature-name
   ```

4. **Make Your Changes**

   - Implement your changes or add new features. Ensure that your code follows Flutter and Dart best practices.
   - If you’re fixing a bug, please include test cases or demonstrate how the issue is resolved.

5. **Commit Your Changes**

   - Write clear and concise commit messages explaining what your changes do.

   ```bash
   git add .
   git commit -m "Add feature/fix description"
   ```

6. **Push to Your Forked Repository**

   - Push your changes to the branch in your forked repository.

   ```bash
   git push origin feature/your-feature-name
   ```

7. **Open a Pull Request (PR)**

   - Go to the original MyQuran repository on GitHub and open a Pull Request from your branch.

   - Describe your changes thoroughly in the PR description, and include screenshots or examples if applicable.

## Code Style

- Run flutter analyze and dart format before committing changes to ensure code quality.

- Use descriptive names for variables, classes, and methods.

## Reporting Issues

- If you find a bug or have a suggestion for a new feature, please open an issue on GitHub.

- Clearly describe the issue or feature request, and if possible, provide steps to reproduce the issue.
