# 貢献ガイドライン

`EcoPaste` に関心と貢献を寄せていただきありがとうございます！プルリクエストを送信する前に、スムーズなプロセスを確保するために以下のガイドラインを確認してください。

## 透明な開発

すべての作業は GitHub 上で公開されています。コアチームメンバーであれ外部の貢献者であれ、すべてのプルリクエストは同じレビュープロセスを通過する必要があります。

## Issue を提出

バグ報告と機能提案のために[GitHub Issues](https://github.com/EcoPasteHub/EcoPaste/issues)を使用しています。

問題を提出する前に、既に対処済みまたは進行中の類似の問題がないか検索してください。

- 機能の提案については、変更内容と期待される動作を記述してください。

- バグレポートについては、問題を再現するための詳細な手順を含めてください。

## Pull Request を提出

### 貢献ワークフロー

- 問題を主張する: GitHub で新しい問題を作成し、または既存のものを主張して他の人に自分が取り組んでいることを知らせ、重複する取り組みを避けます。

- プロジェクト開発: 準備ができたら、ローカル環境でバグ修正や機能開発を進めましょう。

- テスト: 変更が既存の機能を壊さないことを確認するために徹底的にテストしてください。

- PR を提出する。

### セットアップ

- [Rust](https://v1.tauri.app/v1/guides/getting-started/prerequisites/): 公式の指示に従って Rust をインストールしてください。

- [Node.js](https://nodejs.org/en/): プロジェクトの実行に必要です。

- [Pnpm](https://pnpm.io/): このプロジェクトでは、パッケージ管理に Pnpm を使用します。

### 依存関係をインストール

```shell
pnpm install
```

### アプリケーションを開始します

```shell
pnpm tauri dev
```

### アプリケーションの構築

> ビルド後にデバッグする必要がある場合は、以下のコマンドに `--debug` を追加してください

```shell
pnpm tauri build
```

## コミットガイドライン

コミットメッセージには[conventional-changelog 標準](https://www.conventionalcommits.org/ja/v1.0.0/)に従ってください。

### コミットの種類

利用可能な commit タイプ:

- feat: 新機能または機能性
- fix: バグ修正
- docs: ドキュメントの更新
- style: コードスタイルの更新
- refactor: 新機能やバグ修正のないコードリファクタリング
- perf: パフォーマンスの向上
- chore: その他の変更

「エコパス」をより良くするためのあなたの貢献を楽しみにしています!
