﻿/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  09/02/2020         EPPlus Software AB       EPPlus 5.4
 *************************************************************************************************/
namespace OfficeOpenXml.Table.PivotTable
{
    /// <summary>
    /// Defines a pivot table caption period type
    /// </summary>
    public enum ePivotTableDatePeriodFilterType
    {
        /// <summary>
        /// A date filter - Last Month
        /// </summary>
        LastMonth = ePivotTableFilterType.LastMonth,
        /// <summary>
        /// A date filter - Last Quarter
        /// </summary>
        LastQuarter = ePivotTableFilterType.LastQuarter,
        /// <summary>
        /// A date filter - Last Week
        /// </summary>
        LastWeek = ePivotTableFilterType.LastWeek,
        /// <summary>
        /// A date filter - Last Year
        /// </summary>
        LastYear = ePivotTableFilterType.LastYear,
        /// <summary>
        /// A date filter - Januari
        /// </summary>
        M1 = ePivotTableFilterType.M1,
        /// <summary>
        /// A date filter - Februari
        /// </summary>
        M2 = ePivotTableFilterType.M2,
        /// <summary>
        /// A date filter - March
        /// </summary>
        M3 = ePivotTableFilterType.M3,
        /// <summary>
        /// A date filter - April
        /// </summary>
        M4 = ePivotTableFilterType.M4,
        /// <summary>
        /// A date filter - May
        /// </summary>
        M5 = ePivotTableFilterType.M5,
        /// <summary>
        /// A date filter - June
        /// </summary>
        M6 = ePivotTableFilterType.M6,
        /// <summary>
        /// A date filter - July
        /// </summary>
        M7 = ePivotTableFilterType.M7,
        /// <summary>
        /// A date filter - August
        /// </summary>
        M8 = ePivotTableFilterType.M8,
        /// <summary>
        /// A date filter - September
        /// </summary>
        M9 = ePivotTableFilterType.M9,
        /// <summary>
        /// A date filter - October
        /// </summary>
        M10 = ePivotTableFilterType.M10,
        /// <summary>
        /// A date filter - November
        /// </summary>
        M11 = ePivotTableFilterType.M11,
        /// <summary>
        /// A date filter - December
        /// </summary>
        M12 = ePivotTableFilterType.M12,
        /// <summary>
        /// A date filter - Next Month
        /// </summary>
        NextMonth = ePivotTableFilterType.NextMonth,
        /// <summary>
        /// A date filter - Next Quarter
        /// </summary>
        NextQuarter = ePivotTableFilterType.NextQuarter,
        /// <summary>
        /// A date filter - Next Week
        /// </summary>
        NextWeek = ePivotTableFilterType.NextWeek,
        /// <summary>
        /// A date filter - Next Year
        /// </summary>
        NextYear = ePivotTableFilterType.NextYear,
        /// <summary>
        /// A date filter - The First Quarter
        /// </summary>
        Q1 = ePivotTableFilterType.Q1,
        /// <summary>
        /// A date filter - The Second Quarter
        /// </summary>
        Q2 = ePivotTableFilterType.Q2,
        /// <summary>
        /// A date filter - The Third Quarter
        /// </summary>
        Q3 = ePivotTableFilterType.Q3,
        /// <summary>
        /// A date filter - The Forth Quarter
        /// </summary>
        Q4 = ePivotTableFilterType.Q4,
        /// <summary>
        /// A date filter - This Month
        /// </summary>
        ThisMonth = ePivotTableFilterType.ThisMonth,
        /// <summary>
        /// A date filter - This Quarter
        /// </summary>
        ThisQuarter = ePivotTableFilterType.ThisQuarter,
        /// <summary>
        /// A date filter - This Week
        /// </summary>
        ThisWeek = ePivotTableFilterType.ThisWeek,
        /// <summary>
        /// A date filter - This Year
        /// </summary>
        ThisYear = ePivotTableFilterType.ThisYear,
        /// <summary>
        /// A date filter - Today
        /// </summary>
        Today = ePivotTableFilterType.Today,
        /// <summary>
        /// A date filter - Tomorrow
        /// </summary>
        Tomorrow = ePivotTableFilterType.Tomorrow,
        /// <summary>
        /// A date filter - Year to date
        /// </summary>
        YearToDate = ePivotTableFilterType.YearToDate,
        /// <summary>
        /// A date filter - Yesterday
        /// </summary>
        Yesterday = ePivotTableFilterType.Yesterday
    }
}
