/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Style
{
    /// <summary>
    /// Border line style
    /// </summary>
    public enum ExcelBorderStyle
    {
        /// <summary>
        /// No border style
        /// </summary>
        None,
        /// <summary>
        /// Hairline
        /// </summary>
        Hair,
        /// <summary>
        /// Dotted
        /// </summary>
        Dotted,
        /// <summary>
        /// Dash Dot
        /// </summary>
        DashDot,
        /// <summary>
        /// Thin single line
        /// </summary>
        Thin,
        /// <summary>
        /// Dash Dot Dot
        /// </summary>
        DashDotDot,
        /// <summary>
        /// Dashed
        /// </summary>
        Dashed,
        /// <summary>
        /// Dash Dot Dot, medium thickness
        /// </summary>
        MediumDashDotDot,
        /// <summary>
        /// Dashed, medium thickness
        /// </summary>
        MediumDashed,
        /// <summary>
        /// Dash Dot, medium thickness
        /// </summary>
        MediumDashDot,
        /// <summary>
        /// Single line, Thick
        /// </summary>
        Thick,
        /// <summary>
        /// Single line, medium thickness
        /// </summary>
        Medium,
        /// <summary>
        /// Double line
        /// </summary>
        Double
    };
}