/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace OfficeOpenXml.FormulaParsing.ExcelUtilities
{
    /// <summary>
    /// Compares values against wildcard strings
    /// </summary>
    public class WildCardValueMatcher : ValueMatcher
    {
        /// <summary>
        /// Compares two strings
        /// </summary>
        /// <param name="searchedValue">The searched value, might contain wildcard characters</param>
        /// <param name="candidate">The candidate to compare</param>
        /// <returns>0 if match, otherwise -1 or 1</returns>
        protected override int CompareStringToString(string searchedValue, string candidate)
        {
            if (searchedValue.Contains("*") || searchedValue.Contains("?"))
            {
                var regexPattern = BuildRegex(searchedValue, candidate);
                if (Regex.IsMatch(candidate, regexPattern))
                {
                    return 0;
                }
            }
            return base.CompareStringToString(candidate, searchedValue);
        }

        private string BuildRegex(string searchedValue, string candidate)
        {
            var result = new StringBuilder();
            var regexPattern = Regex.Escape(searchedValue);
            regexPattern = regexPattern.Replace("\\*", "*");
            regexPattern = regexPattern.Replace("\\?", "?");
            regexPattern = string.Format("^{0}$", regexPattern);
            var lastIsTilde = false;
            foreach(var ch in regexPattern)
            {
                if(ch == '~')
                {
                    lastIsTilde = true;
                    continue;
                }
                if(ch == '*')
                {
                    if(lastIsTilde)
                    {
                        result.Append("\\*");
                    }
                    else
                    {
                        result.Append(".*");
                    }
                }
                else if(ch == '?')
                {
                    if (lastIsTilde)
                    {
                        result.Append("\\?");
                    }
                    else
                    {
                        result.Append('.');
                    }
                }
                else if(lastIsTilde)
                {
                    result.Append("~" + ch);
                }
                else
                {
                    result.Append(ch);
                }
                lastIsTilde = false;
            }
            return result.ToString();
        }
    }
}
