﻿/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
 05/07/2024         EPPlus Software AB       Initial release EPPlus 7
 *************************************************************************************************/
using OfficeOpenXml.FormulaParsing.Excel.Functions.Helpers;
using OfficeOpenXml.FormulaParsing.Excel.Functions.Metadata;
using OfficeOpenXml.FormulaParsing.FormulaExpressions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OfficeOpenXml.FormulaParsing.Excel.Functions.Statistical
{
    [FunctionMetadata(
        SupportsArrays = true,
        Category = ExcelFunctionCategory.Statistical,
        EPPlusVersion = "7.2.1",
        Description = "Returns the number of areas in a reference. An area is a range of contiguous cells or a single cell.")]


        internal class Areas:ExcelFunction
        {
        public override ExcelFunctionArrayBehaviour ArrayBehaviour => ExcelFunctionArrayBehaviour.Custom;
        public override string NamespacePrefix => "_xlfn.";
        public override int ArgumentMinLength => 1;

        public override CompileResult Execute(IList<FunctionArgument> arguments, ParsingContext context)
        {
            var result = arguments.Count();
            foreach (var arg in arguments)
            {
                if (arg.IsExcelRangeOrSingleCell)
                {
                    if(arg.IsExcelRange && arg.ValueAsRangeInfo.IsInMemoryRange)
                    {
                        return CompileResult.GetErrorResult(eErrorType.Value);
                    }
                }
                else
                {
                    return CompileResult.GetErrorResult(eErrorType.Value);
                }
            }
            return CreateResult(result,DataType.Integer);
        }
    }
}
