/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
using System;
using System.Collections.Generic;
using OfficeOpenXml.Packaging.Ionic.Zip;
using System.Reflection;
using System.IO;
using System.Text;
using OfficeOpenXml.Utils;
using OfficeOpenXml.FormulaParsing.Excel.Functions.MathFunctions;

namespace OfficeOpenXml
{
    /// <summary>
    /// A collection of fonts and there size in pixels used when determining auto widths for columns.
    /// This is used as .NET and Excel does not measure font widths in pixels in a similar way.
    /// </summary>
    public class FontSize
    {
        /// <summary>
        /// Default font used in EPPlus
        /// </summary>
        public const string DefaultFont = "Calibri";
        /// <summary>
        /// Font used in EPPlus if the font name supplied cannot be found
        /// </summary>
        public const string NonExistingFont = "Arial";
        internal static bool _isLoaded = false;
        internal static object _lockObj=new object();
        internal static MemoryStream _fontStream=null;
        /// <summary>
        /// Dictionary containing Font Width in pixels.
        /// You can add your own fonts and sizes here.
        /// </summary>
        public static Dictionary<string, Dictionary<float, short>> FontWidths = new Dictionary<string, Dictionary<float, short>>(StringComparer.OrdinalIgnoreCase)
        {
            {"Calibri Light",new Dictionary<float,short>(){{11f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{17f, 12},{18.5f, 14},{20f, 15},{21.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39.5f, 28},{41f, 29},{42.5f, 31},{44f, 32},{45.5f, 33},{47f, 34},{48.5f, 35},{50f, 36},{51.5f, 37},{53f, 38},{54f, 39},{55.5f, 40},{57f, 41},{58.5f, 42},{60f, 43},{61.5f, 44},{63f, 45},{64.5f, 46},{66f, 48},{67.5f, 49},{69f, 50},{70.5f, 51},{72f, 52}}},
            {"Calibri",new Dictionary<float,short>(){{3f, 3},{5f, 4},{6f, 5},{7.5f, 6},{9.5f, 7},{12f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{17f, 12},{18.5f, 14},{20f, 15},{21.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39.5f, 28},{41f, 29},{42.5f, 31},{44f, 32},{45.5f, 33},{47f, 34},{48.5f, 35},{50f, 36},{51.5f, 37},{53f, 38},{54f, 39},{55.5f, 40},{57f, 41},{58.5f, 42},{60f, 43},{61.5f, 44},{63f, 45},{64.5f, 46},{66f, 48},{67.5f, 49},{69f, 50},{70.5f, 51},{72f, 52}}},
            {"Aptos Display",new Dictionary<float,short>(){{11f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{16.5f, 12},{18f, 14},{19.5f, 15},{21f, 16},{22.5f, 17},{24f, 18},{25.5f, 19},{27f, 20},{28.5f, 21},{30f, 22},{31.5f, 23},{33f, 24},{33.5f, 25},{35f, 26},{36.5f, 27},{38f, 28},{39.5f, 29},{41f, 31},{42.5f, 32},{44f, 33},{45.5f, 34},{47f, 35},{48.5f, 36},{49.5f, 37},{51f, 38},{52.5f, 39},{54f, 40},{55.5f, 41},{57f, 42},{58.5f, 43},{60f, 44},{61.5f, 45},{63f, 46},{64.5f, 48},{66f, 49},{66.5f, 50},{68f, 51},{69.5f, 52},{71f, 53}}},
            {"Aptos Narrow",new Dictionary<float,short>(){}},
            {"Arial",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{14f, 11},{15.5f, 12},{17f, 14},{18.5f, 15},{20f, 16},{21f, 17},{22.5f, 18},{24f, 19},{25.5f, 20},{27f, 21},{27.5f, 22},{29f, 23},{30.5f, 24},{32f, 25},{33.5f, 26},{34.5f, 27},{36f, 28},{37.5f, 29},{39f, 31},{40.5f, 32},{41f, 33},{42.5f, 34},{44f, 35},{45.5f, 36},{47f, 37},{48f, 38},{49.5f, 39},{51f, 40},{52.5f, 41},{54f, 42},{54.5f, 43},{56f, 44},{57.5f, 45},{59f, 46},{60.5f, 48},{61.5f, 49},{63f, 50},{64.5f, 51},{66f, 52},{67.5f, 53},{68f, 54},{69.5f, 55},{71f, 56}}},
            {"Arial Black",new Dictionary<float,short>(){{8f, 7},{9f, 8},{9.5f, 9},{11f, 10},{12f, 11},{13.5f, 12},{14f, 14},{15.5f, 15},{16.5f, 16},{18f, 17},{18.5f, 18},{20f, 19},{21f, 20},{22.5f, 21},{23f, 22},{24.5f, 23},{25.5f, 24},{27f, 25},{27.5f, 26},{29f, 27},{30f, 28},{31.5f, 29},{32f, 31},{33.5f, 32},{34.5f, 33},{36f, 34},{36.5f, 35},{38f, 36},{39f, 37},{40.5f, 38},{41f, 39},{42.5f, 40},{43.5f, 41},{72f, 68}}},
            {"Arial Narrow",new Dictionary<float,short>(){{8f, 5},{9.5f, 6},{11f, 7},{12.5f, 8},{14f, 9},{15.5f, 10},{18f, 11},{19.5f, 12},{21f, 14},{22.5f, 15},{24f, 16},{25.5f, 17},{27.5f, 18},{29f, 19},{30.5f, 20},{32f, 21},{33.5f, 22},{36f, 23},{37.5f, 24},{39f, 25},{40.5f, 26},{42f, 27},{44f, 28},{45.5f, 29},{47f, 31},{48.5f, 32},{50f, 33},{52.5f, 34},{54f, 35},{55.5f, 36},{57f, 37},{58.5f, 38},{60.5f, 39},{62f, 40},{63.5f, 41},{65f, 42},{66.5f, 43},{68f, 44},{70.5f, 45},{72f, 46}}},
            {"Bookman Old Style",new Dictionary<float,short>(){{8f, 7},{9.5f, 8},{10.5f, 9},{12f, 10},{12.5f, 11},{14f, 12},{15.5f, 14},{16.5f, 15},{18f, 16},{18.5f, 17},{20f, 18},{21.5f, 19},{22.5f, 20},{24f, 21},{25.5f, 22},{26f, 23},{27.5f, 24},{28.5f, 25},{30f, 26},{31.5f, 27},{32f, 28},{33.5f, 29},{34.5f, 31},{36f, 32},{37.5f, 33},{38f, 34},{39.5f, 35},{41f, 36},{42f, 37},{43.5f, 38},{44f, 39},{45.5f, 40},{47f, 41},{48f, 42},{49.5f, 43},{50f, 44},{51.5f, 45},{53f, 46},{54f, 48},{55.5f, 49},{56f, 50},{57.5f, 51},{59f, 52},{60f, 53},{61.5f, 54},{63f, 55},{63.5f, 56},{65f, 57},{66f, 58},{67.5f, 59},{69f, 60},{69.5f, 61},{71f, 62},{72f, 63}}},
            {"Calisto MT",new Dictionary<float,short>(){{11f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{17f, 12},{18.5f, 14},{20f, 15},{21.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39f, 28},{40.5f, 29},{42f, 31},{43.5f, 32},{45f, 33},{46.5f, 34},{48f, 35},{49.5f, 36},{51f, 37},{52.5f, 38},{54f, 39},{55.5f, 40},{57f, 41},{58.5f, 42},{60f, 43},{61.5f, 44},{63f, 45},{64.5f, 46},{66f, 48},{67.5f, 49},{69f, 50},{70.5f, 51},{72f, 52}}},
            {"Cambria",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{14f, 11},{15.5f, 12},{17f, 14},{18.5f, 15},{20f, 16},{21f, 17},{22.5f, 18},{24f, 19},{25.5f, 20},{27f, 21},{28.5f, 22},{29f, 23},{30.5f, 24},{32f, 25},{33.5f, 26},{35f, 27},{36f, 28},{37.5f, 29},{39f, 31},{40.5f, 32},{42f, 33},{42.5f, 34},{72f, 56}}},
            {"Cambria Math",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{14f, 11},{15.5f, 12},{17f, 14},{18.5f, 15},{20f, 16},{21f, 17},{22.5f, 18},{24f, 19},{25.5f, 20},{27f, 21},{28.5f, 22},{29f, 23},{30.5f, 24},{32f, 25},{33.5f, 26},{35f, 27},{36f, 28},{37.5f, 29},{39f, 31},{40.5f, 32},{42f, 33},{42.5f, 34},{44f, 35},{45.5f, 36},{47f, 37},{48.5f, 38},{49.5f, 39},{51f, 40},{52.5f, 41},{54f, 42},{55.5f, 43},{56f, 44},{57.5f, 45},{59f, 46},{60.5f, 48},{62f, 49},{63f, 50},{64.5f, 51},{66f, 52},{67.5f, 53},{69f, 54},{69.5f, 55},{71f, 56}}},
            {"Century Gothic",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{14f, 11},{15.5f, 12},{17f, 14},{18.5f, 15},{20f, 16},{21f, 17},{22.5f, 18},{24f, 19},{25.5f, 20},{27f, 21},{27.5f, 22},{29f, 23},{30.5f, 24},{32f, 25},{33.5f, 26},{34.5f, 27},{36f, 28},{37.5f, 29},{39f, 31},{40.5f, 32},{42f, 33},{42.5f, 34},{44f, 35},{45.5f, 36},{47f, 37},{48.5f, 38},{49.5f, 39},{51f, 40},{52.5f, 41},{54f, 42},{55.5f, 43},{56f, 44},{57.5f, 45},{59f, 46},{60.5f, 48},{62f, 49},{63f, 50},{64.5f, 51},{66f, 52},{67.5f, 53},{69f, 54},{69.5f, 55},{71f, 56}}},
            {"Courier New",new Dictionary<float,short>(){{8f, 7},{9.5f, 8},{11f, 9},{12f, 10},{13.5f, 11},{15f, 12},{15.5f, 14},{17f, 15},{18.5f, 16},{19.5f, 17},{21f, 18},{22.5f, 19},{23f, 20},{24.5f, 21},{26f, 22},{27f, 23},{28.5f, 24},{30f, 25},{30.5f, 26},{32f, 27},{33.5f, 28},{34.5f, 29},{36f, 31},{37.5f, 32},{38f, 33},{39.5f, 34},{41f, 35},{42f, 36},{43.5f, 37},{45f, 38},{45.5f, 39},{47f, 40},{48.5f, 41},{49.5f, 42},{51f, 43},{52.5f, 44},{53f, 45},{54.5f, 46},{56f, 48},{57f, 49},{58.5f, 50},{60f, 51},{60.5f, 52},{62f, 53},{63.5f, 54},{64.5f, 55},{66f, 56},{67.5f, 57},{68f, 58},{69.5f, 59},{71f, 60},{72f, 61}}},
            {"Garamond",new Dictionary<float,short>(){{8f, 5},{9f, 6},{10.5f, 7},{12f, 8},{14f, 9},{15.5f, 10},{17f, 11},{18.5f, 12},{20f, 14},{21.5f, 15},{23f, 16},{25.5f, 17},{27f, 18},{28.5f, 19},{30f, 20},{31.5f, 21},{33f, 22},{34.5f, 23},{36f, 24},{38f, 25},{39.5f, 26},{41f, 27},{42.5f, 28},{44f, 29},{45.5f, 31},{47f, 32},{49.5f, 33},{51f, 34},{52.5f, 35},{54f, 36},{55.5f, 37},{57f, 38},{58.5f, 39},{60f, 40},{62f, 41},{63.5f, 42},{65f, 43},{66.5f, 44},{68f, 45},{69.5f, 46},{71f, 48}}},
            {"Georgia",new Dictionary<float,short>(){{8f, 8},{9.5f, 9},{12f, 10},{13.5f, 11},{14f, 12},{15.5f, 14},{16.5f, 15},{18f, 16},{19.5f, 17},{20f, 18},{21.5f, 19},{23f, 20},{24f, 21},{25.5f, 22},{27f, 23},{27.5f, 24},{29f, 25},{30f, 26},{31.5f, 27},{33f, 28},{33.5f, 29},{35f, 31},{36.5f, 32},{37.5f, 33},{39f, 34},{39.5f, 35},{41f, 36},{42.5f, 37},{43.5f, 38},{45f, 39},{46.5f, 40},{47f, 41},{48.5f, 42},{49.5f, 43},{51f, 44},{52.5f, 45},{53f, 46},{54.5f, 48},{56f, 49},{57f, 50},{58.5f, 51},{60f, 52},{60.5f, 53},{62f, 54},{63f, 55},{64.5f, 56},{66f, 57},{66.5f, 58},{68f, 59},{69.5f, 60},{70.5f, 61},{72f, 62}}},
            {"Gill Sans MT",new Dictionary<float,short>(){{11f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{17f, 12},{18.5f, 14},{20f, 15},{21.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39.5f, 28},{41f, 29},{42.5f, 31},{44f, 32},{45.5f, 33},{47f, 34},{48.5f, 35},{50f, 36},{51.5f, 37},{53f, 38},{54.5f, 39},{56f, 40},{57.5f, 41},{59f, 42},{60.5f, 43},{62f, 44},{63.5f, 45},{65f, 46},{66.5f, 48},{68f, 49},{69.5f, 50},{71f, 51}}},
            {"Impact",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{15f, 11},{16.5f, 12},{18f, 14},{18.5f, 15},{20f, 16},{21.5f, 17},{23f, 18},{24.5f, 19},{26f, 20},{27f, 21},{28.5f, 22},{30f, 23},{31.5f, 24},{33f, 25},{34.5f, 26},{36f, 27},{36.5f, 28},{38f, 29},{39.5f, 31},{41f, 32},{42.5f, 33},{72f, 55}}},
            {"Liberation Serif",new Dictionary<float,short>(){{10.5f, 7},{12f, 8},{12.5f, 9},{15f, 10},{15.5f, 11},{18f, 12},{19.5f, 14},{20f, 15},{22.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39.5f, 28},{41f, 29},{42.5f, 31},{44f, 32},{45.5f, 33},{47f, 34},{48.5f, 35},{50f, 36},{51.5f, 37},{53f, 38},{54.5f, 39},{56f, 40},{57.5f, 41},{59f, 42},{60.5f, 43},{62f, 44},{63.5f, 45},{65f, 46},{66.5f, 48},{68f, 49},{69.5f, 50},{71f, 51}}},
            {"Rockwell",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{15f, 11},{16.5f, 12},{18f, 14},{18.5f, 15},{20f, 16},{21.5f, 17},{23f, 18},{24.5f, 19},{26f, 20},{27f, 21},{28.5f, 22},{30f, 23},{31.5f, 24},{33f, 25},{34.5f, 26},{36f, 27},{36.5f, 28},{38f, 29},{39.5f, 31},{41f, 32},{42.5f, 33},{44f, 34},{45f, 35},{46.5f, 36},{48f, 37},{49.5f, 38},{51f, 39},{52.5f, 40},{54f, 41},{54.5f, 42},{56f, 43},{57.5f, 44},{59f, 45},{60.5f, 46},{62f, 48},{63f, 49},{64.5f, 50},{66f, 51},{67.5f, 52},{69f, 53},{70.5f, 54},{72f, 55}}},
            {"Rockwell Condensed",new Dictionary<float,short>(){{8f, 4},{9.5f, 5},{12f, 6},{13.5f, 7},{15.5f, 8},{18f, 9},{20f, 10},{21.5f, 11},{24f, 12},{26f, 14},{27.5f, 15},{30f, 16},{32f, 17},{34.5f, 18},{36f, 19},{38f, 20},{40.5f, 21},{42.5f, 22},{44f, 23},{46.5f, 24},{48.5f, 25},{51f, 26},{52.5f, 27},{54.5f, 28},{57f, 29},{59f, 31},{60.5f, 32},{63f, 33},{65f, 34},{66.5f, 35},{69f, 36},{71f, 37}}},
            {"Times New Roman",new Dictionary<float,short>(){{10.5f, 7},{12f, 8},{12.5f, 9},{15f, 10},{15.5f, 11},{18f, 12},{19.5f, 14},{20f, 15},{22.5f, 16},{23f, 17},{24.5f, 18},{26f, 19},{27.5f, 20},{29f, 21},{30.5f, 22},{32f, 23},{33.5f, 24},{35f, 25},{36.5f, 26},{38f, 27},{39.5f, 28},{41f, 29},{42.5f, 31},{44f, 32},{45.5f, 33},{47f, 34},{48.5f, 35},{50f, 36},{51.5f, 37},{53f, 38},{54.5f, 39},{56f, 40},{57.5f, 41},{59f, 42},{60.5f, 43},{62f, 44},{63.5f, 45},{65f, 46},{66.5f, 48},{68f, 49},{69.5f, 50},{71f, 51}}},
            {"Trebuchet MS",new Dictionary<float,short>(){{11f, 8},{12.5f, 9},{14f, 10},{15.5f, 11},{16.5f, 12},{18f, 14},{19.5f, 15},{21f, 16},{22.5f, 17},{24f, 18},{25.5f, 19},{27f, 20},{28.5f, 21},{30f, 22},{30.5f, 23},{32f, 24},{33.5f, 25},{35f, 26},{36.5f, 27},{38f, 28},{39.5f, 29},{41f, 31},{42.5f, 32},{44f, 33},{45.5f, 34},{46.5f, 35},{48f, 36},{49.5f, 37},{51f, 38},{52.5f, 39},{54f, 40},{55.5f, 41},{57f, 42},{58.5f, 43},{60f, 44},{61.5f, 45},{62f, 46},{63.5f, 48},{65f, 49},{66.5f, 50},{68f, 51},{69.5f, 52},{71f, 53}}},
            {"Tw Cen MT",new Dictionary<float,short>(){{9f, 7},{10.5f, 8},{12f, 9},{13.5f, 10},{15f, 11},{15.5f, 12},{17f, 14},{18.5f, 15},{20f, 16},{21.5f, 17},{22.5f, 18},{24f, 19},{25.5f, 20},{27f, 21},{28.5f, 22},{29f, 23},{30.5f, 24},{32f, 25},{33.5f, 26},{35f, 27},{36.5f, 28},{37.5f, 29},{39f, 31},{40.5f, 32},{42f, 33},{43.5f, 34},{44f, 35},{45.5f, 36},{47f, 37},{48.5f, 38},{50f, 39},{51f, 40},{52.5f, 41},{54f, 42},{55.5f, 43},{57f, 44},{58.5f, 45},{59f, 46},{60.5f, 48},{62f, 49},{63.5f, 50},{65f, 51},{66f, 52},{67.5f, 53},{69f, 54},{70.5f, 55},{72f, 56}}},
            {"Tw Cen MT Condensed",new Dictionary<float,short>(){{8f, 4},{9.5f, 5},{12f, 6},{13.5f, 7},{15.5f, 8},{18f, 9},{19.5f, 10},{21.5f, 11},{24f, 12},{26f, 14},{27.5f, 15},{30f, 16},{32f, 17},{34.5f, 18},{36f, 19},{38f, 20},{40.5f, 21},{42.5f, 22},{72f, 37}}},
            {"Verdana",new Dictionary<float,short>(){{8f, 7},{9f, 8},{10.5f, 9},{11f, 10},{12.5f, 11},{14f, 12},{15f, 14},{16.5f, 15},{17f, 16},{18.5f, 17},{19.5f, 18},{21f, 19},{22.5f, 20},{23f, 21},{24.5f, 22},{25.5f, 23},{27f, 24},{27.5f, 25},{29f, 26},{30.5f, 27},{31.5f, 28},{33f, 29},{33.5f, 31},{35f, 32},{36f, 33},{37.5f, 34},{39f, 35},{39.5f, 36},{41f, 37},{42f, 38},{43.5f, 39},{44f, 40},{45.5f, 41},{47f, 42},{48f, 43},{49.5f, 44},{50f, 45},{51.5f, 46},{52.5f, 48},{54f, 49},{55.5f, 50},{56f, 51},{57.5f, 52},{58.5f, 53},{60f, 54},{60.5f, 55},{62f, 56},{63.5f, 57},{64.5f, 58},{66f, 59},{66.5f, 60},{68f, 61},{69.5f, 62},{70.5f, 63},{72f, 65}}}
        };

        /// <summary>
        /// Dictionary containing default Font Heights in pixels for the row height calculates.
        /// You can add your own fonts and sizes here.
        /// </summary>
        public static Dictionary<string, Dictionary<float, short>> FontHeights = new Dictionary<string, Dictionary<float, short>>(StringComparer.OrdinalIgnoreCase)
        {
            {"Calibri Light",new Dictionary<float,short>(){}},
            {"Calibri",new Dictionary<float,short>(){{3f, 8},{3.5f, 9},{5f, 11},{6.5f, 12},{7.5f, 13},{8f, 15},{9f, 16},{9.5f, 17},{10.5f, 19},{11f, 20},{12f, 21},{12.5f, 23},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 31},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 37},{21.5f, 38},{22.5f, 39},{23f, 40},{24f, 42},{24.5f, 43},{25.5f, 44},{26f, 45},{27f, 47},{27.5f, 48},{28.5f, 49},{29f, 50},{30f, 52},{30.5f, 53},{31.5f, 54},{32f, 56},{33f, 57},{33.5f, 58},{34.5f, 59},{35f, 61},{36f, 62},{36.5f, 63},{37.5f, 64},{38f, 66},{39f, 67},{39.5f, 68},{40.5f, 70},{41f, 71},{42f, 72},{42.5f, 73},{43.5f, 75},{44f, 76},{45f, 77},{45.5f, 78},{46.5f, 80},{47f, 81},{48f, 82},{48.5f, 83},{49.5f, 85},{50f, 86},{51f, 87},{51.5f, 89},{52.5f, 90},{53f, 91},{54f, 92},{54.5f, 94},{55.5f, 95},{56f, 96},{57f, 97},{57.5f, 99},{58.5f, 100},{59f, 101},{60f, 102},{60.5f, 104},{61.5f, 105},{62f, 106},{63f, 108},{63.5f, 109},{64.5f, 110},{65f, 111},{66f, 113},{66.5f, 114},{67.5f, 115},{68f, 116},{69f, 118},{69.5f, 119},{70.5f, 120},{71f, 122},{72f, 123}}},
            {"Arial",new Dictionary<float,short>(){{10.5f, 18},{11f, 19},{12f, 20},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 25},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 31},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 36},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 41},{25.5f, 42},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 48},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 52},{32f, 54},{33f, 55},{33.5f, 56},{34.5f, 57},{35f, 58},{36f, 59},{36.5f, 61},{37.5f, 62},{38f, 63},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 68},{42f, 70},{42.5f, 71},{43.5f, 72},{44f, 73},{45f, 74},{45.5f, 75},{46.5f, 76},{47f, 78},{48f, 79},{48.5f, 80},{49.5f, 81},{50f, 83},{51f, 84},{51.5f, 85},{52.5f, 87},{53f, 88},{54f, 89},{54.5f, 90},{55.5f, 91},{56f, 92},{57f, 93},{57.5f, 97},{58.5f, 98},{59f, 99},{60f, 100},{60.5f, 102},{61.5f, 103},{62f, 104},{63f, 106},{63.5f, 107},{64.5f, 108},{65f, 109},{66f, 111},{66.5f, 112},{68f, 114},{69f, 115},{69.5f, 116},{70.5f, 117},{71f, 119},{72f, 120}}},
            {"Aptos Display",new Dictionary<float,short>(){{9.5f, 18},{10.5f, 19},{11f, 20},{12f, 21},{12.5f, 23},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 32},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 37},{21.5f, 38},{22.5f, 39},{23f, 41},{24f, 42},{24.5f, 43},{25.5f, 44},{26f, 46},{27f, 47},{27.5f, 48},{28.5f, 49},{29f, 51},{30f, 52},{30.5f, 53},{31.5f, 55},{32f, 56},{33f, 57},{33.5f, 58},{34.5f, 60},{35f, 61},{36f, 62},{36.5f, 63},{37.5f, 65},{38f, 66},{39f, 69},{39.5f, 71},{40.5f, 72},{41f, 73},{42f, 74},{42.5f, 76},{43.5f, 77},{44f, 78},{45f, 79},{45.5f, 81},{46.5f, 82},{47f, 83},{48f, 85},{48.5f, 86},{49.5f, 87},{50f, 88},{51f, 90},{51.5f, 91},{52.5f, 92},{53f, 94},{54f, 95},{54.5f, 96},{55.5f, 97},{56f, 99},{57f, 100},{57.5f, 101},{58.5f, 102},{59f, 104},{60f, 105},{60.5f, 106},{61.5f, 108},{62f, 109},{63f, 110},{63.5f, 111},{64.5f, 113},{65f, 114},{66f, 115},{66.5f, 116},{67.5f, 118},{68f, 119},{69f, 120},{69.5f, 122},{70.5f, 123},{71f, 124},{72f, 125}}},
            {"Aptos Narrow",new Dictionary<float,short>(){{9.5f, 18},{10.5f, 19},{11f, 20},{12f, 21},{12.5f, 23},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 32},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 37},{21.5f, 38},{22.5f, 39},{23f, 41},{24f, 42},{24.5f, 43},{25.5f, 44},{26f, 46},{27f, 47},{27.5f, 48},{28.5f, 49},{29f, 51},{30f, 52},{30.5f, 53},{31.5f, 55},{32f, 56},{33f, 57},{33.5f, 58},{34.5f, 60},{35f, 61},{36f, 62},{36.5f, 63},{37.5f, 65},{38f, 66},{39f, 69},{39.5f, 71},{40.5f, 72},{41f, 73},{42f, 74},{42.5f, 76},{43.5f, 77},{44f, 78},{45f, 79},{45.5f, 81},{46.5f, 82},{47f, 83},{48f, 85},{48.5f, 86},{49.5f, 87},{50f, 88},{51f, 90},{51.5f, 91},{52.5f, 92},{53f, 94},{54f, 95},{54.5f, 96},{55.5f, 97},{56f, 99},{57f, 100},{57.5f, 101},{58.5f, 102},{59f, 104},{60f, 105},{60.5f, 106},{61.5f, 108},{62f, 109},{63f, 110},{63.5f, 111},{64.5f, 113},{65f, 114},{66f, 115},{66.5f, 116},{67.5f, 118},{68f, 119},{69f, 120},{69.5f, 122},{70.5f, 123},{71f, 124},{72f, 125}}},
            {"Arial Black",new Dictionary<float,short>(){{8f, 17},{9f, 19},{9.5f, 20},{10.5f, 21},{11f, 25},{12f, 26},{12.5f, 27},{13.5f, 29},{14f, 30},{15f, 31},{15.5f, 33},{16.5f, 34},{17f, 35},{18f, 36},{18.5f, 40},{19.5f, 41},{20f, 42},{21f, 44},{21.5f, 45},{22.5f, 46},{23f, 48},{24f, 49},{24.5f, 50},{25.5f, 52},{26f, 55},{27f, 56},{27.5f, 57},{28.5f, 59},{29f, 60},{30f, 61},{30.5f, 63},{31.5f, 64},{32f, 65},{33f, 67},{33.5f, 70},{34.5f, 71},{35f, 73},{36f, 74},{36.5f, 75},{37.5f, 76},{38f, 78},{39f, 79},{39.5f, 80},{40.5f, 82},{41f, 85},{42f, 86},{42.5f, 88},{43.5f, 89},{72f, 147}}},
            {"Arial Narrow",new Dictionary<float,short>(){{8f, 17},{9f, 18},{9.5f, 17},{10.5f, 18},{11f, 22},{12f, 21},{12.5f, 23},{14f, 24},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 30},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 36},{22.5f, 39},{24f, 40},{24.5f, 42},{25.5f, 43},{26f, 45},{27.5f, 47},{28.5f, 48},{29f, 49},{30f, 50},{30.5f, 52},{32f, 54},{33.5f, 56},{34.5f, 58},{36f, 61},{37.5f, 62},{38f, 63},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 69},{42f, 70},{42.5f, 71},{44f, 74},{45.5f, 76},{46.5f, 77},{47f, 78},{48f, 80},{49.5f, 82},{50f, 83},{51f, 84},{51.5f, 86},{52.5f, 87},{53f, 88},{54f, 89},{54.5f, 91},{55.5f, 92},{57f, 94},{57.5f, 96},{59f, 97},{60f, 99},{60.5f, 100},{61.5f, 102},{62f, 103},{63f, 104},{63.5f, 105},{64.5f, 106},{65f, 108},{66f, 109},{66.5f, 110},{67.5f, 112},{69f, 113},{69.5f, 114},{70.5f, 116},{71f, 118}}},
            {"Bookman Old Style",new Dictionary<float,short>(){{8f, 17},{9.5f, 20},{10.5f, 21},{11f, 20},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 37},{22.5f, 38},{23f, 41},{24f, 42},{24.5f, 44},{25.5f, 43},{26f, 44},{27f, 45},{27.5f, 47},{28.5f, 48},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 53},{32f, 54},{33f, 55},{33.5f, 57},{34.5f, 58},{35f, 59},{36f, 61},{37.5f, 63},{38f, 64},{39f, 67},{39.5f, 68},{40.5f, 69},{41f, 71},{42f, 72},{42.5f, 73},{43.5f, 74},{44f, 76},{45f, 77},{45.5f, 78},{46.5f, 79},{47f, 81},{48f, 82},{48.5f, 83},{49.5f, 84},{50f, 85},{51f, 87},{51.5f, 88},{52.5f, 89},{53f, 91},{54f, 92},{54.5f, 93},{55.5f, 94},{56f, 96},{57f, 97},{57.5f, 98},{58.5f, 99},{59f, 101},{60.5f, 103},{61.5f, 104},{62f, 105},{63f, 106},{63.5f, 108},{64.5f, 109},{65f, 110},{66f, 111},{66.5f, 113},{67.5f, 114},{68f, 115},{69f, 116},{69.5f, 119},{70.5f, 121},{71f, 122},{72f, 123}}},
            {"Calisto MT",new Dictionary<float,short>(){{10.5f, 18},{11f, 19},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 37},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 42},{25.5f, 43},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 48},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 53},{32f, 54},{33f, 55},{33.5f, 56},{34.5f, 58},{35f, 59},{36f, 60},{36.5f, 61},{37.5f, 62},{38f, 64},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 69},{42f, 70},{42.5f, 71},{43.5f, 72},{44f, 74},{45f, 75},{45.5f, 76},{46.5f, 77},{47f, 78},{48f, 80},{48.5f, 81},{49.5f, 82},{50f, 83},{51f, 85},{51.5f, 86},{52.5f, 87},{53f, 88},{54f, 90},{54.5f, 91},{55.5f, 92},{56f, 93},{57f, 94},{57.5f, 96},{58.5f, 97},{59f, 98},{60f, 99},{60.5f, 101},{61.5f, 102},{62f, 103},{63f, 104},{63.5f, 106},{64.5f, 107},{65f, 108},{66f, 109},{66.5f, 110},{67.5f, 112},{68f, 113},{69f, 114},{69.5f, 115},{70.5f, 117},{71f, 118},{72f, 119}}},
            {"Cambria",new Dictionary<float,short>(){{8f, 14},{9f, 16},{9.5f, 17},{10.5f, 18},{11f, 19},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 25},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 30},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 36},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 41},{25.5f, 43},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 47},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 52},{32f, 54},{33f, 55},{33.5f, 56},{34.5f, 57},{35f, 58},{36f, 60},{36.5f, 61},{37.5f, 62},{38f, 63},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 68},{42f, 69},{42.5f, 71},{43.5f, 72},{72f, 118}}},
            {"Cambria Math",new Dictionary<float,short>(){{8f, 85},{9f, 93},{9.5f, 102},{10.5f, 109},{11f, 117},{12f, 124},{12.5f, 132},{13.5f, 139},{14f, 147},{15f, 154},{15.5f, 162},{16.5f, 171},{17f, 179},{18f, 186},{18.5f, 194},{19.5f, 201},{20f, 209},{21f, 216},{21.5f, 223},{22.5f, 233},{23f, 240},{24f, 248},{24.5f, 255},{25.5f, 263},{26f, 270},{27f, 278},{27.5f, 285},{28.5f, 293},{29f, 302},{30f, 310},{30.5f, 317},{31.5f, 324},{32f, 332},{33f, 339},{33.5f, 347},{34.5f, 354},{35f, 362},{36f, 371},{36.5f, 379},{37.5f, 386},{38f, 394},{39f, 401},{39.5f, 409},{40.5f, 416},{41f, 423},{42f, 433},{42.5f, 440},{43.5f, 448},{44f, 455},{45f, 463},{45.5f, 470},{46.5f, 478},{47f, 485},{48f, 493},{48.5f, 502},{49.5f, 510},{50f, 517},{51f, 525},{51.5f, 532},{52.5f, 539},{53f, 547},{54f, 554},{54.5f, 564},{55.5f, 571},{56f, 579},{57f, 586},{57.5f, 594},{58.5f, 601},{59f, 609},{60f, 616},{60.5f, 624},{61.5f, 633},{62f, 640},{63f, 648},{63.5f, 655},{64.5f, 663},{65f, 670},{66f, 678},{66.5f, 685},{67.5f, 695},{68f, 702},{69f, 710},{69.5f, 717},{70.5f, 725},{71f, 732},{72f, 739}}},
            {"Century Gothic",new Dictionary<float,short>(){{8f, 18},{9f, 19},{9.5f, 18},{10.5f, 21},{11f, 22},{12f, 23},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 25},{15.5f, 26},{16.5f, 27},{17f, 28},{18f, 32},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 36},{21.5f, 38},{22.5f, 39},{23f, 38},{24f, 41},{24.5f, 42},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 47},{29f, 48},{30f, 51},{30.5f, 52},{31.5f, 53},{32f, 54},{33f, 60},{33.5f, 59},{34.5f, 60},{35f, 61},{36.5f, 62},{37.5f, 65},{38f, 66},{39f, 65},{39.5f, 66},{40.5f, 68},{42f, 73},{42.5f, 74},{43.5f, 75},{44f, 76},{45f, 78},{45.5f, 79},{46.5f, 82},{47f, 81},{48f, 82},{48.5f, 84},{49.5f, 83},{50f, 84},{51f, 87},{51.5f, 88},{52.5f, 86},{53f, 89},{54f, 90},{54.5f, 91},{55.5f, 92},{56f, 94},{57f, 95},{57.5f, 96},{58.5f, 97},{59f, 98},{60f, 100},{60.5f, 101},{61.5f, 102},{62f, 103},{63f, 104},{63.5f, 106},{64.5f, 109},{65f, 108},{66f, 109},{66.5f, 110},{67.5f, 111},{68f, 113},{69f, 114},{69.5f, 115},{70.5f, 116},{71f, 117},{72f, 119}}},
            {"Courier New",new Dictionary<float,short>(){{9.5f, 18},{10.5f, 19},{11f, 20},{12f, 21},{12.5f, 23},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 32},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 37},{21.5f, 38},{22.5f, 39},{23f, 40},{24f, 42},{24.5f, 43},{25.5f, 44},{26f, 46},{27f, 47},{27.5f, 48},{28.5f, 49},{29f, 51},{30f, 52},{30.5f, 53},{31.5f, 55},{32f, 56},{33f, 57},{33.5f, 58},{34.5f, 60},{35f, 61},{36f, 62},{36.5f, 63},{37.5f, 65},{38f, 66},{39f, 67},{39.5f, 69},{40.5f, 70},{41f, 71},{42f, 72},{42.5f, 74},{43.5f, 75},{44f, 76},{45f, 77},{45.5f, 79},{46.5f, 80},{47f, 81},{48f, 83},{48.5f, 84},{49.5f, 85},{50f, 86},{51f, 88},{51.5f, 89},{52.5f, 90},{53f, 91},{54f, 93},{54.5f, 94},{55.5f, 95},{56f, 97},{57f, 98},{57.5f, 99},{58.5f, 100},{59f, 102},{60f, 103},{60.5f, 104},{61.5f, 105},{62f, 107},{63f, 108},{63.5f, 109},{64.5f, 111},{65f, 112},{66f, 113},{66.5f, 114},{67.5f, 116},{68f, 117},{69f, 118},{69.5f, 119},{70.5f, 121},{71f, 122},{72f, 123}}},
            {"Garamond",new Dictionary<float,short>(){{12.5f, 22},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 31},{18.5f, 33},{19.5f, 34},{20f, 35},{21f, 36},{21.5f, 38},{22.5f, 39},{23f, 40},{24f, 41},{24.5f, 43},{25.5f, 44},{26f, 45},{27f, 46},{27.5f, 48},{28.5f, 49},{29f, 50},{30f, 52},{30.5f, 53},{31.5f, 54},{32f, 55},{33f, 57},{33.5f, 58},{34.5f, 59},{35f, 60},{36f, 62},{36.5f, 63},{37.5f, 64},{38f, 65},{39f, 67},{39.5f, 68},{40.5f, 69},{41f, 70},{42f, 72},{42.5f, 73},{43.5f, 74},{44f, 76},{45f, 77},{45.5f, 78},{46.5f, 79},{47f, 81},{48f, 82},{48.5f, 83},{49.5f, 84},{50f, 86},{51f, 87},{51.5f, 88},{52.5f, 89},{53f, 91},{54f, 92},{54.5f, 93},{55.5f, 94},{56f, 96},{57f, 97},{57.5f, 98},{58.5f, 100},{59f, 101},{60f, 102},{60.5f, 103},{61.5f, 105},{62f, 106},{63f, 107},{63.5f, 108},{64.5f, 110},{65f, 111},{66f, 112},{66.5f, 113},{67.5f, 115},{68f, 116},{69f, 117},{69.5f, 118},{70.5f, 120},{71f, 121},{72f, 122}}},
            {"Georgia",new Dictionary<float,short>(){{10.5f, 18},{11f, 19},{12f, 20},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 26},{15.5f, 27},{16.5f, 29},{17f, 30},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 36},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 41},{25.5f, 42},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 47},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 52},{32f, 53},{33f, 55},{33.5f, 56},{34.5f, 57},{35f, 58},{36f, 60},{36.5f, 61},{37.5f, 63},{38f, 64},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 68},{42f, 70},{42.5f, 71},{43.5f, 72},{44f, 73},{45f, 74},{45.5f, 75},{46.5f, 77},{47f, 78},{48f, 79},{48.5f, 81},{49.5f, 82},{50f, 83},{51f, 84},{51.5f, 85},{52.5f, 87},{53f, 88},{54f, 89},{54.5f, 91},{55.5f, 92},{56f, 93},{57f, 94},{57.5f, 95},{58.5f, 96},{59f, 98},{60f, 99},{60.5f, 100},{61.5f, 102},{62f, 103},{63f, 104},{63.5f, 105},{64.5f, 106},{65f, 107},{66f, 108},{66.5f, 109},{67.5f, 111},{68f, 112},{69f, 113},{69.5f, 115},{70.5f, 116},{71f, 117},{72f, 118}}},
            {"Gill Sans MT",new Dictionary<float,short>(){{8f, 18},{9f, 21},{9.5f, 20},{10.5f, 24},{11f, 23},{12f, 26},{12.5f, 28},{13.5f, 30},{14f, 29},{15f, 32},{15.5f, 33},{17f, 36},{18f, 37},{18.5f, 36},{19.5f, 37},{20f, 41},{21f, 42},{21.5f, 43},{22.5f, 45},{23f, 47},{24f, 48},{24.5f, 49},{25.5f, 50},{26f, 51},{27f, 55},{27.5f, 56},{28.5f, 55},{29f, 56},{30f, 59},{30.5f, 61},{31.5f, 64},{32f, 63},{33f, 64},{33.5f, 67},{35f, 68},{36f, 71},{36.5f, 70},{37.5f, 73},{38f, 75},{39f, 74},{39.5f, 78},{40.5f, 77},{41f, 81},{42f, 82},{42.5f, 83},{43.5f, 84},{44f, 85},{45f, 87},{45.5f, 90},{46.5f, 89},{47f, 90},{48f, 91},{48.5f, 94},{49.5f, 93},{50f, 98},{51.5f, 101},{53f, 102},{54f, 103},{54.5f, 106},{56f, 109},{57.5f, 112},{58.5f, 111},{59f, 115},{60f, 116},{60.5f, 117},{61.5f, 118},{62f, 119},{63.5f, 124},{64.5f, 123},{65f, 124},{66f, 126},{66.5f, 128},{67.5f, 127},{68f, 132},{69f, 131},{69.5f, 132},{70.5f, 134},{71f, 135},{72f, 139}}},
            {"Impact",new Dictionary<float,short>(){{8f, 18},{9.5f, 19},{10.5f, 20},{11f, 21},{12f, 22},{13.5f, 23},{14f, 24},{15f, 27},{15.5f, 28},{17f, 29},{18f, 30},{18.5f, 35},{19.5f, 36},{21f, 37},{21.5f, 38},{22.5f, 39},{23f, 41},{24f, 40},{24.5f, 43},{25.5f, 44},{26f, 45},{27.5f, 46},{28.5f, 47},{29f, 48},{30f, 49},{30.5f, 53},{31.5f, 54},{32f, 55},{33f, 56},{33.5f, 59},{35f, 62},{36f, 63},{36.5f, 64},{37.5f, 66},{38f, 65},{39f, 66},{39.5f, 67},{40.5f, 68},{42f, 69},{42.5f, 74},{43.5f, 75},{72f, 119}}},
            {"Liberation Serif",new Dictionary<float,short>(){{8f, 14},{9f, 16},{9.5f, 17},{10.5f, 18},{11f, 19},{12f, 20},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 25},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 30},{18.5f, 31},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 36},{22.5f, 37},{23f, 39},{24f, 40},{24.5f, 41},{25.5f, 42},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 47},{29f, 48},{30f, 50},{30.5f, 51},{31.5f, 52},{32f, 53},{33f, 55},{33.5f, 56},{34.5f, 57},{35f, 58},{36f, 59},{36.5f, 61},{37.5f, 62},{38f, 63},{39f, 64},{39.5f, 65},{40.5f, 67},{41f, 68},{42f, 69},{42.5f, 70},{43.5f, 72},{44f, 75},{45f, 76},{45.5f, 77},{46.5f, 78},{47f, 80},{48f, 81},{48.5f, 82},{49.5f, 83},{50f, 84},{51f, 86},{51.5f, 87},{52.5f, 88},{53f, 89},{54f, 91},{54.5f, 92},{55.5f, 93},{56f, 94},{57f, 95},{57.5f, 97},{58.5f, 98},{59f, 99},{60f, 100},{60.5f, 102},{61.5f, 103},{62f, 104},{63f, 105},{63.5f, 106},{64.5f, 108},{65f, 109},{66f, 110},{66.5f, 111},{67.5f, 112},{68f, 114},{69f, 115},{69.5f, 116},{70.5f, 117},{71f, 119},{72f, 120}}},
            {"Rockwell",new Dictionary<float,short>(){{8f, 14},{9f, 16},{9.5f, 17},{10.5f, 18},{11f, 19},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 25},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 30},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 36},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 41},{25.5f, 43},{26f, 44},{27f, 45},{27.5f, 46},{28.5f, 47},{29f, 49},{30f, 50},{30.5f, 51},{31.5f, 52},{32f, 54},{33f, 55},{33.5f, 56},{34.5f, 57},{35f, 58},{36f, 60},{36.5f, 61},{37.5f, 62},{38f, 63},{39f, 65},{39.5f, 66},{40.5f, 67},{41f, 69},{42f, 70},{42.5f, 71},{43.5f, 72},{44f, 74},{45f, 75},{45.5f, 76},{46.5f, 77},{47f, 78},{48f, 80},{48.5f, 81},{49.5f, 82},{50f, 83},{51f, 84},{51.5f, 86},{52.5f, 87},{53f, 88},{54f, 89},{54.5f, 90},{55.5f, 92},{56f, 93},{57f, 94},{57.5f, 95},{58.5f, 97},{59f, 98},{60f, 99},{60.5f, 100},{61.5f, 101},{62f, 103},{63f, 104},{63.5f, 105},{64.5f, 106},{65f, 107},{66f, 109},{66.5f, 110},{67.5f, 111},{68f, 112},{69f, 114},{69.5f, 115},{70.5f, 116},{71f, 117},{72f, 118}}},
            {"Rockwell Condensed",new Dictionary<float,short>(){{10.5f, 18},{11f, 20},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 24},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 36},{21.5f, 37},{22.5f, 38},{23f, 39},{24f, 41},{24.5f, 42},{25.5f, 43},{26f, 44},{27f, 45},{27.5f, 47},{28.5f, 48},{29f, 49},{30f, 50},{30.5f, 52},{31.5f, 53},{32f, 54},{33f, 55},{33.5f, 57},{34.5f, 58},{35f, 59},{36f, 60},{36.5f, 62},{37.5f, 63},{38f, 64},{39f, 65},{39.5f, 66},{40.5f, 68},{41f, 69},{42f, 70},{42.5f, 71},{43.5f, 73},{44f, 74},{45f, 75},{45.5f, 76},{46.5f, 78},{47f, 79},{48f, 80},{48.5f, 81},{49.5f, 83},{50f, 84},{51f, 85},{51.5f, 86},{52.5f, 87},{53f, 89},{54f, 90},{54.5f, 91},{55.5f, 92},{56f, 94},{57f, 95},{57.5f, 96},{58.5f, 97},{59f, 99},{60f, 100},{60.5f, 101},{61.5f, 102},{62f, 103},{63f, 105},{63.5f, 106},{64.5f, 107},{65f, 108},{66f, 110},{66.5f, 111},{67.5f, 112},{68f, 113},{69f, 115},{69.5f, 116},{70.5f, 117},{71f, 118},{72f, 120}}},
            {"Times New Roman",new Dictionary<float,short>(){{10.5f, 18},{11f, 20},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 25},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 30},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 35},{21f, 36},{21.5f, 37},{22.5f, 38},{23f, 39},{24f, 41},{24.5f, 42},{25.5f, 43},{26f, 44},{27f, 46},{27.5f, 47},{28.5f, 48},{29f, 49},{30f, 51},{30.5f, 52},{31.5f, 53},{32f, 54},{33f, 56},{33.5f, 57},{34.5f, 58},{35f, 59},{36f, 61},{36.5f, 62},{37.5f, 63},{38f, 64},{39f, 66},{39.5f, 67},{40.5f, 68},{41f, 69},{42f, 71},{42.5f, 72},{43.5f, 73},{44f, 76},{45f, 77},{45.5f, 79},{46.5f, 80},{47f, 81},{48f, 82},{48.5f, 84},{49.5f, 85},{50f, 86},{51f, 87},{51.5f, 89},{52.5f, 90},{53f, 91},{54f, 92},{54.5f, 94},{55.5f, 95},{56f, 96},{57f, 97},{57.5f, 99},{58.5f, 100},{59f, 101},{60f, 102},{60.5f, 104},{61.5f, 105},{62f, 106},{63f, 107},{63.5f, 109},{64.5f, 110},{65f, 111},{66f, 112},{66.5f, 113},{67.5f, 115},{68f, 116},{69f, 117},{69.5f, 118},{70.5f, 120},{71f, 121},{72f, 122}}},
            {"Trebuchet MS",new Dictionary<float,short>(){{8f, 18},{9f, 20},{10.5f, 19},{11f, 22},{12f, 24},{14f, 25},{15f, 27},{15.5f, 28},{16.5f, 29},{17f, 30},{18f, 31},{18.5f, 33},{19.5f, 34},{20f, 37},{21f, 38},{22.5f, 39},{23f, 40},{24f, 41},{24.5f, 43},{25.5f, 45},{27f, 46},{27.5f, 48},{28.5f, 50},{30f, 51},{30.5f, 53},{31.5f, 54},{32f, 56},{33f, 57},{33.5f, 58},{34.5f, 59},{35f, 61},{36f, 62},{36.5f, 63},{37.5f, 64},{38f, 66},{39f, 68},{40.5f, 69},{41f, 70},{42f, 73},{42.5f, 74},{44f, 75},{45f, 78},{45.5f, 79},{47f, 81},{48f, 82},{48.5f, 84},{49.5f, 85},{50f, 86},{51f, 87},{51.5f, 89},{52.5f, 90},{53f, 91},{54f, 92},{54.5f, 93},{55.5f, 95},{56f, 97},{57.5f, 98},{58.5f, 100},{59f, 102},{60.5f, 103},{61.5f, 106},{62f, 107},{63f, 108},{64.5f, 110},{65f, 112},{66f, 113},{66.5f, 114},{67.5f, 115},{68f, 117},{69f, 118},{69.5f, 119},{70.5f, 120},{71f, 121},{72f, 123}}},
            {"Tw Cen MT",new Dictionary<float,short>(){{10.5f, 18},{11f, 19},{12f, 21},{12.5f, 22},{13.5f, 23},{14f, 25},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 30},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 36},{21.5f, 37},{22.5f, 38},{23f, 39},{24f, 40},{24.5f, 42},{25.5f, 43},{26f, 44},{27f, 46},{27.5f, 47},{28.5f, 48},{29f, 49},{30f, 51},{30.5f, 52},{31.5f, 53},{32f, 54},{33f, 55},{33.5f, 57},{34.5f, 58},{35f, 59},{36f, 60},{36.5f, 61},{37.5f, 63},{38f, 64},{39f, 65},{39.5f, 67},{40.5f, 68},{41f, 69},{42f, 71},{43.5f, 72},{44f, 74},{45f, 75},{45.5f, 76},{46.5f, 77},{47f, 79},{48f, 80},{48.5f, 81},{49.5f, 82},{50f, 84},{51f, 85},{51.5f, 86},{52.5f, 88},{53f, 89},{54f, 90},{54.5f, 91},{55.5f, 92},{56f, 93},{57f, 95},{57.5f, 96},{58.5f, 97},{59f, 98},{60f, 100},{60.5f, 101},{61.5f, 102},{62f, 103},{63f, 105},{63.5f, 106},{64.5f, 107},{65f, 109},{66f, 110},{66.5f, 111},{67.5f, 112},{68f, 113},{69f, 114},{69.5f, 116},{70.5f, 117},{71f, 118},{72f, 119}}},
            {"Tw Cen MT Condensed",new Dictionary<float,short>(){{8f, 14},{9f, 16},{9.5f, 17},{10.5f, 18},{11f, 19},{12f, 21},{12.5f, 22},{13.5f, 24},{14f, 25},{15f, 26},{15.5f, 27},{16.5f, 28},{17f, 29},{18f, 31},{18.5f, 32},{19.5f, 33},{20f, 34},{21f, 35},{21.5f, 37},{22.5f, 38},{23f, 39},{24f, 41},{24.5f, 42},{25.5f, 43},{26f, 45},{27f, 46},{27.5f, 48},{29f, 50},{30f, 51},{31.5f, 53},{32f, 54},{33f, 56},{33.5f, 57},{34.5f, 58},{35f, 60},{36f, 61},{36.5f, 63},{38f, 64},{39f, 66},{39.5f, 67},{40.5f, 68},{41f, 70},{42f, 71},{42.5f, 72},{43.5f, 73},{72f, 120}}},
            {"Verdana",new Dictionary<float,short>(){{8f, 14},{9f, 15},{9.5f, 17},{10.5f, 18},{11f, 19},{12f, 20},{12.5f, 21},{13.5f, 23},{14f, 24},{15f, 27},{15.5f, 26},{16.5f, 27},{17f, 29},{18f, 30},{18.5f, 33},{19.5f, 34},{20f, 33},{21f, 35},{21.5f, 36},{22.5f, 37},{23f, 40},{24f, 39},{24.5f, 41},{25.5f, 42},{26f, 43},{27f, 46},{27.5f, 47},{29f, 48},{30f, 49},{30.5f, 50},{31.5f, 53},{33f, 54},{33.5f, 55},{34.5f, 56},{35f, 59},{36f, 61},{36.5f, 60},{37.5f, 61},{38f, 62},{39f, 63},{39.5f, 67},{40.5f, 66},{41f, 67},{42f, 68},{42.5f, 69},{43.5f, 73},{44f, 74},{45f, 75},{45.5f, 74},{46.5f, 75},{47f, 77},{48f, 80},{48.5f, 79},{49.5f, 80},{50f, 81},{51f, 83},{51.5f, 86},{52.5f, 87},{53f, 86},{54f, 87},{54.5f, 89},{55.5f, 90},{56f, 93},{57f, 94},{57.5f, 93},{58.5f, 95},{59f, 96},{60f, 99},{60.5f, 100},{62f, 101},{63f, 102},{63.5f, 103},{64.5f, 106},{65f, 108},{66f, 107},{66.5f, 108},{67.5f, 109},{68f, 112},{69f, 115},{69.5f, 114},{70.5f, 115},{71f, 116},{72f, 117}}},

        };

        internal static decimal GetWidthPixels(string fontName, float fontSize)
        {
            return GetWidthHeight(fontName, fontSize, true, 7);
        }
        internal static decimal GetHeightPixels(string fontName, float fontSize)
        {
            return GetWidthHeight(fontName, fontSize, false, 20);
        }

        private static decimal GetWidthHeight(string fontName, float fontSize, bool width, decimal defaultValue)
        {
            var font = GetFontSize(fontName, width);

            if (font.ContainsKey(fontSize))
            {
                return Convert.ToDecimal(font[fontSize]);
            }
            else
            {
                float min = -1;
                foreach (var size in font.Keys)
                {
                    if (min < size && size > fontSize)
                    {
                        break;
                    }
                    min =
                    min = size;
                }
                if (min > fontSize && fontName.Equals(DefaultFont, StringComparison.OrdinalIgnoreCase))
                {
                    //If value is less than the stored size for the font, it's assumed to be the same as the default font(Calibri).
                    return GetWidthHeight(DefaultFont, fontSize, width, defaultValue);
                }
                if (min > -1)
                {
                    if(fontSize > 72)
                    {
                        return Convert.ToDecimal((int)(font[min] / min * fontSize)); 
                    }
                    return font[min];
                }
                return defaultValue;  //Default, Calibri 11;
            }

        }
        /// <summary>
        /// Get the font info for either height or width
        /// </summary>
        /// <param name="fontName">The font name</param>
        /// <param name="width">If true, FontWidth is used, else FontHeights</param>
        /// <returns></returns>
        internal static Dictionary<float, short> GetFontSize(string fontName, bool width)
        {
            var fontColl = width ? FontWidths : FontHeights;
            if (fontColl.ContainsKey(fontName))
            {
                return fontColl[fontName];
            }
            else
            {
                if (_isLoaded==false)
                {
                    LoadAllFontsFromResource();
                    if (fontColl.ContainsKey(fontName))
                    {
                        return fontColl[fontName];
                    }
                }
                return fontColl["Calibri"];
            }
        }

        /// <summary>
        /// Load the fonts default heights/widths from the internal resource file
        /// </summary>
        public static void LoadAllFontsFromResource()
        {
            LoadFontsFromResource(null);
            if (_fontStream != null)
            {
                _fontStream.Dispose();
                _fontStream = null;
            }
        }
        /// <summary>
        /// Load the specified fonts default heights/widths from the internal resource file
        /// </summary>
        /// <param name="fontName">The name of the font.</param>
        /// <param name="disposeStream">If false the stream is loading the font is kept open to load other fonts faster. It true the font-stream is disposed on exit.</param>
        public static void LoadFontsFromResource(string fontName, bool disposeStream=true)
        {            
            lock (_lockObj)
            {
                if (_isLoaded) return;
                if(_fontStream!=null)
                {
                    ReadFontSize(_fontStream, fontName);
                    _isLoaded = string.IsNullOrEmpty(fontName);
                }
                var assembly = Assembly.GetExecutingAssembly();
                var stream = assembly.GetManifestResourceStream("OfficeOpenXml.resources.fontsize.zip");

                using (stream)
                {
                    using (var zipStream = new ZipInputStream(stream))
                    {
                        ZipEntry entry;
                        while ((entry = zipStream.GetNextEntry()) != null)
                        {
                            if (entry.FileName.Equals("fontsize.bin", StringComparison.OrdinalIgnoreCase))
                            {
                                var br = new BinaryReader(zipStream);
                                if (string.IsNullOrEmpty(fontName))
                                {
                                    using (var ms = RecyclableMemory.GetStream(br.ReadBytes((int)entry.UncompressedSize)))
                                    {
                                        ReadFontSize(ms, fontName);
                                    }
                                    _isLoaded = true;
                                }
                                else
                                {
                                    _fontStream = RecyclableMemory.GetStream(br.ReadBytes((int)entry.UncompressedSize));
                                    ReadFontSize(_fontStream, fontName);
                                }
                            }
                        }
                    }
                }
                if (disposeStream && _fontStream!=null)
                {
                    _fontStream.Dispose();
                    _fontStream = null;
                }
            }
        }        
        private static void ReadFontSize(MemoryStream stream, string fontName)
        {
            var br = new BinaryReader(stream);
            var noFonts = br.ReadUInt16();
            //Read all font names first
            var fonts = new Dictionary<string, uint>();
            var fno = 0;
            while (fno<noFonts)
            {
                var nameSize = (short)br.ReadByte();
                var name = Encoding.ASCII.GetString(br.ReadBytes(nameSize));
                var dataPos = br.ReadUInt32();
                if (fontName == null || fontName.Equals(name, StringComparison.OrdinalIgnoreCase))
                {
                    fonts.Add(name, dataPos);
                }
                fno++;
            }
            
            foreach(var font in fonts)
            {
                AddFont(br, font.Key, font.Value);
            }
        }

        private static void AddFont(BinaryReader br, string fontName, uint dataPos)
        {
            var fontHeights = new Dictionary<float, short>();
            var fontWidths = new Dictionary<float, short>();
            br.BaseStream.Position = dataPos;
            var length = br.ReadUInt16();
            var pos = 0; 
            while (pos < length)
            {
                var s = br.ReadUInt16();
                var v = br.ReadUInt16();
                if ((v & 0x8000) == 0)
                {
                    fontWidths.Add(s / 100F, (short)v);
                }
                else
                {
                    v &= 0x7FFF;
                    fontHeights.Add(s / 100F, (short)v);
                }
                pos += 4;
            }
            if (FontWidths.ContainsKey(fontName) == false)
            {
                FontWidths.Add(fontName, fontWidths);
            }
            if (FontHeights.ContainsKey(fontName) == false)
            {
                FontHeights.Add(fontName, fontHeights);
            }
        }
    }
}
