/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// System colors
    /// </summary>s
    public enum eSystemColor
    {       
        /// <summary>
        /// Scroll Bar System Color
        /// </summary>
        ScrollBar,
        /// <summary>
        /// Background System Color
        /// </summary>
        Background,
        /// <summary>
        /// Active Caption System Color
        /// </summary>
        ActiveCaption,
        /// <summary>
        /// Inactive Caption System Color
        /// </summary>
        InactiveCaption,
        /// <summary>
        /// Menu System Color
        /// </summary>
        Menu,
        /// <summary>
        /// Window Background System Color
        /// </summary>
        Window,
        /// <summary>
        /// Window Frame System Color
        /// </summary>
        WindowFrame,
        /// <summary>
        /// Menu Text System Color
        /// </summary>
        MenuText,
        /// <summary>
        /// Window Text System Color
        /// </summary>
        WindowText,
        /// <summary>
        /// Caption Text System Color
        /// </summary>
        CaptionText,
        /// <summary>
        /// Active Border System Color
        /// </summary>
        ActiveBorder,
        /// <summary>
        /// Inactive Border System Color
        /// </summary>
        InactiveBorder,
        /// <summary>
        /// Application Workspace System Color
        /// </summary>
        AppWorkspace,
        /// <summary>
        /// Highlight System Color
        /// </summary>
        Highlight,
        /// <summary>
        /// Highlight Text System Color
        /// </summary>
        HighlightText,
        /// <summary>
        /// Button Face System Color
        /// </summary>
        ButtonFace,
        /// <summary>
        /// Button Shadow System Color
        /// </summary>
        ButtonShadow,
        /// <summary>
        /// Gray Text System Color
        /// </summary>
        GrayText,
        /// <summary>
        /// Button Text System Color
        /// </summary>
        ButtonText,
        /// <summary>
        /// Inactive Caption Text System Color
        /// </summary>
        InactiveCaptionText,
        /// <summary>
        /// Button Highlight System Color
        /// </summary>
        ButtonHighlight,
        /// <summary>
        /// 3D Dark System Color
        /// </summary>
        DarkShadow3d,
        /// <summary>
        /// 3D Light System Color
        /// </summary>
        Light3d,
        /// <summary>
        /// Info Text System Color (Tooltip)
        /// </summary>
        InfoText,
        /// <summary>
        /// Info Background System Color (Tooltip)
        /// </summary>
        InfoBackground,
        /// <summary>
        /// Hot Light System Color
        /// </summary>
        HotLight,
        /// <summary>
        /// Gradient Active Caption System Color
        /// </summary>
        GradientActiveCaption,
        /// <summary>
        /// Gradient Inactive Caption System Color
        /// </summary>
        GradientInactiveCaption,
        /// <summary>
        /// Menu Highlight System Color
        /// </summary>
        MenuHighlight,
        /// <summary>
        /// Menu Bar System Color
        /// </summary>
        MenuBar
    }
}