/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// A color bound to a user's theme.
    /// </summary>
    public enum eSchemeColor
    {
        /// <summary>
        /// Semantic background color
        /// </summary>
        Background1,
        /// <summary>
        /// Semantic additional text color
        /// </summary>
        Text1,
        /// <summary>
        /// Semantic additional background color
        /// </summary>
        Background2,
        /// <summary>
        /// Semantic text color
        /// </summary>
        Text2,
        /// <summary>
        /// Extra scheme color 1
        /// </summary>
        Accent1,
        /// <summary>
        /// Extra scheme color 2
        /// </summary>
        Accent2,
        /// <summary>
        /// Extra scheme color 3
        /// </summary>
        Accent3,
        /// <summary>
        /// Extra scheme color 4
        /// </summary>
        Accent4,
        /// <summary>
        /// Extra scheme color 5
        /// </summary>
        Accent5,
        /// <summary>
        /// Extra scheme color 6
        /// </summary>
        Accent6,
        /// <summary>
        /// Regular Hyperlink Color
        /// </summary>
        Hyperlink,
        /// <summary>
        /// Followed Hyperlink Color
        /// </summary>
        FollowedHyperlink,
        /// <summary>
        /// A color used in theme definitions which means to use the color of the style
        /// </summary>
        Style,
        /// <summary>
        /// Main Dark Color 1
        /// </summary>
        Dark1,
        /// <summary>
        /// Main Light Color 1
        /// </summary>
        Light1,
        /// <summary>
        /// Main Dark Color 2
        /// </summary>
        Dark2,
        /// <summary>
        /// Main Light Color 2
        /// </summary>
        Light2
    }
}