/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// The preset type of light rig which is to be applied to the 3D scene
    /// </summary>
    public enum eRigPresetType
    {
        /// <summary>
        /// No rig
        /// </summary>
        None,
        /// <summary>
        /// Balanced
        /// </summary>
        Balanced,
        /// <summary>
        /// Bright Room
        /// </summary>
        BrightRoom,
        /// <summary>
        /// Chilly
        /// </summary>
        Chilly,
        /// <summary>
        /// Contrasting
        /// </summary>
        Contrasting,
        /// <summary>
        /// Flat
        /// </summary>
        Flat,
        /// <summary>
        /// Flood
        /// </summary>
        Flood,
        /// <summary>
        /// Freezing
        /// </summary>
        Freezing,
        /// <summary>
        /// Glow
        /// </summary>
        Glow,
        /// <summary>
        /// Harsh
        /// </summary>
        Harsh,
        /// <summary>
        /// Legacy Flat 1
        /// </summary>
        LegacyFlat1,
        /// <summary>
        /// Legacy Flat 2
        /// </summary>
        LegacyFlat2,
        /// <summary>
        /// Legacy Flat 3
        /// </summary>
        LegacyFlat3,
        /// <summary>
        /// Legacy Flat 4
        /// </summary>
        LegacyFlat4,
        /// <summary>
        /// Legacy Harsh 1
        /// </summary>
        LegacyHarsh1,
        /// <summary>
        /// Legacy Harsh 2
        /// </summary>
        LegacyHarsh2,
        /// <summary>
        /// Legacy Harsh 3
        /// </summary>
        LegacyHarsh3,
        /// <summary>
        /// Legacy Harsh 4
        /// </summary>
        LegacyHarsh4,
        /// <summary>
        /// Legacy Normal 1
        /// </summary>
        LegacyNormal1,
        /// <summary>
        /// Legacy Normal 2
        /// </summary>
        LegacyNormal2,
        /// <summary>
        /// Legacy Normal 3
        /// </summary>
        LegacyNormal3,
        /// <summary>
        /// Legacy Normal 4
        /// </summary>
        LegacyNormal4,
        /// <summary>
        /// Morning
        /// </summary>
        Morning,
        /// <summary>
        /// Soft
        /// </summary>
        Soft,
        /// <summary>
        /// Sunrise
        /// </summary>
        Sunrise,
        /// <summary>
        /// Sunset
        /// </summary>
        Sunset, 
        /// <summary>
        /// Three Point
        /// </summary>
        ThreePt,
        /// <summary>
        /// Two Point
        /// </summary>
        TwoPt, 
    }
}