/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// Preset shadow types in Excel
    /// </summary>
    public enum ePresetExcelShadowType
    {
        /// <summary>
        /// No shadow
        /// </summary>
        None,
        /// <summary>
        /// Inner top left
        /// </summary>
        InnerTopLeft,
        /// <summary>
        /// Inner top
        /// </summary>
        InnerTop,
        /// <summary>
        /// Inner top right
        /// </summary>
        InnerTopRight,
        /// <summary>
        /// Inner left
        /// </summary>
        InnerLeft,
        /// <summary>
        /// Inner center
        /// </summary>
        InnerCenter,
        /// <summary>
        /// Inner right
        /// </summary>
        InnerRight,
        /// <summary>
        /// Inner bottom left
        /// </summary>
        InnerBottomLeft,
        /// <summary>
        /// Inner bottom
        /// </summary>
        InnerBottom,
        /// <summary>
        /// Inner bottom right
        /// </summary>
        InnerBottomRight,
        /// <summary>
        /// Outer top left
        /// </summary>
        OuterTopLeft,
        /// <summary>
        /// Outer top
        /// </summary>
        OuterTop,
        /// <summary>
        /// Outer top right
        /// </summary>
        OuterTopRight,
        /// <summary>
        /// Outer left
        /// </summary>
        OuterLeft,
        /// <summary>
        /// Outer center
        /// </summary>
        OuterCenter,
        /// <summary>
        /// Outer right
        /// </summary>
        OuterRight,
        /// <summary>
        /// Outer bottom left
        /// </summary>
        OuterBottomLeft,
        /// <summary>
        /// Outer bottom
        /// </summary>
        OuterBottom,
        /// <summary>
        /// Outer bottom right
        /// </summary>
        OuterBottomRight,
        /// <summary>
        /// Perspective upper left
        /// </summary>
        PerspectiveUpperLeft,
        /// <summary>
        /// Perspective upper right
        /// </summary>
        PerspectiveUpperRight,
        /// <summary>
        /// Perspective upper below
        /// </summary>
        PerspectiveBelow,
        /// <summary>
        /// Perspective lower left
        /// </summary>
        PerspectiveLowerLeft,
        /// <summary>
        /// Perspective upper right
        /// </summary>
        PerspectiveLowerRight
    }
}