/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// The direction from which the light rig is oriented in relation to the scene.
    /// </summary>
    public enum eLightRigDirection
    {
        /// <summary>
        /// Bottom
        /// </summary>
        Bottom,
        /// <summary>
        /// Bottom Left
        /// </summary>
        BottomLeft,
        /// <summary>
        /// Bottom Right
        /// </summary>
        BottomRight,
        /// <summary>
        /// Left
        /// </summary>
        Left,
        /// <summary>
        /// Right
        /// </summary>
        Right,
        /// <summary>
        /// Top
        /// </summary>
        Top,
        /// <summary>
        /// Top Left
        /// </summary>
        TopLeft,
        /// <summary>
        /// Top Right
        /// </summary>
        TopRight
    }
}