/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// Pattern styles for drawing fills
    /// </summary>
    public enum eFillPatternStyle
    {
        /// <summary>
        /// 5 Percent
        /// </summary>
        Pct5,
        /// <summary>
        /// 10 Percent
        /// </summary>
        Pct10,
        /// <summary>
        /// 20 Percent
        /// </summary>
        Pct20,
        /// <summary>
        /// 25 Percent
        /// </summary>
        Pct25,
        /// <summary>
        /// 30 Percent
        /// </summary>
        Pct30,
        /// <summary>
        /// 40 Percent
        /// </summary>
        Pct40,
        /// <summary>
        /// 50 Percent
        /// </summary>
        Pct50,
        /// <summary>
        /// 60 Percent
        /// </summary>
        Pct60,
        /// <summary>
        /// 70 Percent
        /// </summary>
        Pct70,
        /// <summary>
        /// 75 Percent
        /// </summary>
        Pct75,
        /// <summary>
        /// 80 Percent
        /// </summary>
        Pct80,
        /// <summary>
        /// 90 Percent
        /// </summary>
        Pct90,
        /// <summary>
        /// Horizontal
        /// </summary>
        Horz,
        /// <summary>
        /// Vertical
        /// </summary>
        Vert,
        /// <summary>
        /// Light Horizontal
        /// </summary>
        LtHorz,
        /// <summary>
        /// Light Vertical
        /// </summary>
        LtVert,
        /// <summary>
        /// Dark Horizontal
        /// </summary>
        DkHorz,
        /// <summary>
        /// Dark Vertical
        /// </summary>
        DkVert,
        /// <summary>
        /// Narrow Horizontal
        /// </summary>
        NarHorz,
        /// <summary>
        /// Narrow Vertical
        /// </summary>
        NarVert,
        /// <summary>
        /// Dashed Horizontal
        /// </summary>
        DashHorz,
        /// <summary>
        /// Dashed Vertical
        /// </summary>
        DashVert,
        /// <summary>
        /// Cross
        /// </summary>
        Cross,
        /// <summary>
        /// Downward Diagonal
        /// </summary>
        DnDiag,
        /// <summary>
        /// Upward Diagonal
        /// </summary>
        UpDiag,
        /// <summary>
        /// Light Downward Diagonal
        /// </summary>
        LtDnDiag,
        /// <summary>
        /// Light Upward Diagonal
        /// </summary>
        LtUpDiag,
        /// <summary>
        /// Dark Downward Diagonal
        /// </summary>
        DkDnDiag,
        /// <summary>
        /// Dark Upward Diagonal
        /// </summary>
        DkUpDiag,
        /// <summary>
        /// Wide Downward Diagonal
        /// </summary>
        WdDnDiag,
        /// <summary>
        /// Wide Upward Diagonal
        /// </summary>
        WdUpDiag,
        /// <summary>
        /// Dashed Downward Diagonal
        /// </summary>
        DashDnDiag,
        /// <summary>
        /// Dashed Upward DIagonal
        /// </summary>
        DashUpDiag,
        /// <summary>
        /// Diagonal Cross
        /// </summary>
        DiagCross,
        /// <summary>
        /// Small Checker Board
        /// </summary>
        SmCheck,
        /// <summary>
        /// Large Checker Board
        /// </summary>
        LgCheck,
        /// <summary>
        /// Small Grid
        /// </summary>
        SmGrid,
        /// <summary>
        /// Large Grid
        /// </summary>
        LgGrid,
        /// <summary>
        /// Dotted Grid
        /// </summary>
        DotGrid,
        /// <summary>
        /// Small Confetti
        /// </summary>
        SmConfetti,
        /// <summary>
        /// Large Confetti
        /// </summary>
        LgConfetti,
        /// <summary>
        /// Horizontal Brick
        /// </summary>
        HorzBrick,
        /// <summary>
        /// Diagonal Brick
        /// </summary>
        DiagBrick,
        /// <summary>
        /// Solid Diamond
        /// </summary>
        SolidDmnd,
        /// <summary>
        /// Open Diamond
        /// </summary>
        OpenDmnd,
        /// <summary>
        /// Dotted Diamond
        /// </summary>
        DotDmnd,
        /// <summary>
        /// Plaid
        /// </summary>
        Plaid,
        /// <summary>
        /// Sphere
        /// </summary>
        Sphere,
        /// <summary>
        /// Weave
        /// </summary>
        Weave,
        /// <summary>
        /// Divot
        /// </summary>
        Divot,
        /// <summary>
        /// Shingle
        /// </summary>
        Shingle,
        /// <summary>
        /// Wave
        /// </summary>
        Wave,
        /// <summary>
        /// Trellis
        /// </summary>
        Trellis,
        /// <summary>
        /// Zig Zag
        /// </summary>
        ZigZag
    }
}