/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
 *************************************************************************************************/
namespace OfficeOpenXml.Drawing
{
    /// <summary>
    /// A preset bevel that can be applied to a shape.
    /// </summary>
    public enum eBevelPresetType
    {
        /// <summary>
        /// No Bevel
        /// </summary>
        None,
        /// <summary>
        /// Angle
        /// </summary>
        Angle,
        /// <summary>
        /// Round Convex
        /// </summary>
        ArtDeco,
        /// <summary>
        /// Round
        /// </summary>
        Circle,
        /// <summary>
        /// Convex
        /// </summary>
        Convex,
        /// <summary>
        /// Cool slant
        /// </summary>
        CoolSlant,
        /// <summary>
        /// Cross
        /// </summary>
        Cross,
        /// <summary>
        /// Divot
        /// </summary>
        Divot,
        /// <summary>
        /// Hard Edge
        /// </summary>
        HardEdge,
        /// <summary>
        /// Relaxed Inset
        /// </summary>
        RelaxedInset,
        /// <summary>
        /// Riblet
        /// </summary>
        Riblet,
        /// <summary>
        /// Slope
        /// </summary>
        Slope,
        /// <summary>
        /// Soft Round
        /// </summary>
        SoftRound
    }
}