﻿/*************************************************************************************************
  Required Notice: Copyright (C) EPPlus Software AB. 
  This software is licensed under PolyForm Noncommercial License 1.0.0 
  and may only be used for noncommercial purposes 
  https://polyformproject.org/licenses/noncommercial/1.0.0/

  A commercial license to use this software can be purchased at https://epplussoftware.com
 *************************************************************************************************
  Date               Author                       Change
 *************************************************************************************************
  01/27/2020         EPPlus Software AB       Initial release EPPlus 5
  07/07/2023         EPPlus Software AB       Epplus 7
 *************************************************************************************************/
using OfficeOpenXml.ConditionalFormatting.Contracts;
using OfficeOpenXml.Utils;
using System.Globalization;
using System.Xml;

namespace OfficeOpenXml.ConditionalFormatting.Rules
{
    internal class ExcelConditionalFormattingExpression : ExcelConditionalFormattingRule,
    IExcelConditionalFormattingExpression
    {
        internal ExcelConditionalFormattingExpression(
          ExcelAddress address,
          int priority,
          ExcelWorksheet worksheet)
          : base(
                eExcelConditionalFormattingRuleType.Expression,
                address,
                priority,
                worksheet
                )
        {
            Formula = string.Empty;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="address"></param>
        /// <param name="worksheet"></param>
        /// <param name="xr"></param>
        internal ExcelConditionalFormattingExpression(
          ExcelAddress address,
          ExcelWorksheet worksheet,
          XmlReader xr)
          : base(
                eExcelConditionalFormattingRuleType.Expression,
        address,
                worksheet,
                xr)
        {
        }

        internal ExcelConditionalFormattingExpression(ExcelConditionalFormattingExpression copy, ExcelWorksheet newWs) : base(copy, newWs)
        {

        }

        internal override ExcelConditionalFormattingRule Clone(ExcelWorksheet newWs = null)
        {
            return new ExcelConditionalFormattingExpression(this, newWs);
        }

        internal override bool ShouldApplyToCell(ExcelAddress address)
        {
            var result = _ws.Workbook.FormulaParserManager.Parse(GetCellFormula(address), address.FullAddress, false);
            calculatedFormula1 = string.Format(result.ToString(), CultureInfo.InvariantCulture);
            if (ExcelErrorValue.IsErrorValue(calculatedFormula1))
            {
                return false;
            }

            return ConvertUtil.GetValueBool(result) ?? false;
        }
    }
}
