﻿using System.Collections.Generic;

namespace OfficeOpenXml.ConditionalFormatting
{
    internal static class IconDict
    {
        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeArrows =
    new List<eExcelconditionalFormattingCustomIcon>()
    { eExcelconditionalFormattingCustomIcon.RedDownArrow, eExcelconditionalFormattingCustomIcon.YellowSideArrow, eExcelconditionalFormattingCustomIcon.GreenUpArrow};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeArrowsGray =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.GrayDownArrow, eExcelconditionalFormattingCustomIcon.YellowSideArrow, eExcelconditionalFormattingCustomIcon.GrayUpArrow};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeFlags =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedFlag, eExcelconditionalFormattingCustomIcon.YellowFlag, eExcelconditionalFormattingCustomIcon.GreenFlag};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeSigns =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedDiamond, eExcelconditionalFormattingCustomIcon.YellowTriangle, eExcelconditionalFormattingCustomIcon.GreenCircle};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeSymbols =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedCrossSymbol, eExcelconditionalFormattingCustomIcon.YellowExclamationSymbol, eExcelconditionalFormattingCustomIcon.GreenCheckSymbol};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeSymbols2 =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedCross, eExcelconditionalFormattingCustomIcon.YellowExclamation, eExcelconditionalFormattingCustomIcon.GreenCheck};

        static readonly List<eExcelconditionalFormattingCustomIcon> TrafficLights1 =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedCircle, eExcelconditionalFormattingCustomIcon.YellowCircle, eExcelconditionalFormattingCustomIcon.GreenCircle};

        static readonly List<eExcelconditionalFormattingCustomIcon> TrafficLights2 =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedTrafficLight, eExcelconditionalFormattingCustomIcon.YellowTrafficLight, eExcelconditionalFormattingCustomIcon.GreenTrafficLight};

        static readonly List<eExcelconditionalFormattingCustomIcon> Stars =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.SilverStar, eExcelconditionalFormattingCustomIcon.HalfGoldStar, eExcelconditionalFormattingCustomIcon.GoldStar};

        static readonly List<eExcelconditionalFormattingCustomIcon> ThreeTriangles =
            new List<eExcelconditionalFormattingCustomIcon>()
            { eExcelconditionalFormattingCustomIcon.RedDownTriangle, eExcelconditionalFormattingCustomIcon.YellowDash, eExcelconditionalFormattingCustomIcon.GreenUpTriangle};
        //4 iconsets:

        static readonly List<eExcelconditionalFormattingCustomIcon> FourArrows =
            new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.RedDownArrow, eExcelconditionalFormattingCustomIcon.YellowDownInclineArrow, eExcelconditionalFormattingCustomIcon.YellowUpInclineArrow ,eExcelconditionalFormattingCustomIcon.GreenUpArrow };

        static readonly List<eExcelconditionalFormattingCustomIcon> FourArrowsGray =
            new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.GrayDownArrow, eExcelconditionalFormattingCustomIcon.GrayDownInclineArrow, eExcelconditionalFormattingCustomIcon.GrayUpInclineArrow ,eExcelconditionalFormattingCustomIcon.GrayUpArrow };

        static readonly List<eExcelconditionalFormattingCustomIcon> FourRating =
            new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.SignalMeterWithOneFilledBar, eExcelconditionalFormattingCustomIcon.SignalMeterWithTwoFilledBars, eExcelconditionalFormattingCustomIcon.SignalMeterWithThreeFilledBars ,eExcelconditionalFormattingCustomIcon.SignalMeterWithFourFilledBars };

        static readonly List<eExcelconditionalFormattingCustomIcon> FourRedToBlack =
            new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.BlackCircle, eExcelconditionalFormattingCustomIcon.GrayCircle, eExcelconditionalFormattingCustomIcon.PinkCircle ,eExcelconditionalFormattingCustomIcon.RedCircle };

        static readonly List<eExcelconditionalFormattingCustomIcon> FourTrafficLights =
            new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.BlackCircleWithBorder, eExcelconditionalFormattingCustomIcon.RedCircle, eExcelconditionalFormattingCustomIcon.YellowCircle ,eExcelconditionalFormattingCustomIcon.GreenCircle };

        //5 iconsets:
        static readonly List<eExcelconditionalFormattingCustomIcon> FiveArrows =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.RedDownArrow, eExcelconditionalFormattingCustomIcon.YellowDownInclineArrow, eExcelconditionalFormattingCustomIcon.YellowSideArrow, eExcelconditionalFormattingCustomIcon.YellowUpInclineArrow ,eExcelconditionalFormattingCustomIcon.GreenUpArrow };

        static readonly List<eExcelconditionalFormattingCustomIcon> FiveArrowsGray =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.GrayDownArrow, eExcelconditionalFormattingCustomIcon.GrayDownInclineArrow, eExcelconditionalFormattingCustomIcon.GraySideArrow, eExcelconditionalFormattingCustomIcon.GrayUpInclineArrow ,eExcelconditionalFormattingCustomIcon.GrayUpArrow };

        static readonly List<eExcelconditionalFormattingCustomIcon> FiveQuarters =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.WhiteCircle, eExcelconditionalFormattingCustomIcon.CircleWithThreeWhiteQuarters, eExcelconditionalFormattingCustomIcon.CircleWithTwoWhiteQuarters, eExcelconditionalFormattingCustomIcon.CircleWithOneWhiteQuarter ,eExcelconditionalFormattingCustomIcon.BlackCircle };

        static readonly List<eExcelconditionalFormattingCustomIcon> FiveRating =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.SignalMeterWithNoFilledBars, eExcelconditionalFormattingCustomIcon.SignalMeterWithOneFilledBar, eExcelconditionalFormattingCustomIcon.SignalMeterWithTwoFilledBars, eExcelconditionalFormattingCustomIcon.SignalMeterWithThreeFilledBars ,eExcelconditionalFormattingCustomIcon.SignalMeterWithFourFilledBars };

        static readonly List<eExcelconditionalFormattingCustomIcon> FiveBoxes =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.ZeroFilledBoxes, eExcelconditionalFormattingCustomIcon.OneFilledBox, eExcelconditionalFormattingCustomIcon.TwoFilledBoxes, eExcelconditionalFormattingCustomIcon.ThreeFilledBoxes ,eExcelconditionalFormattingCustomIcon.FourFilledBoxes };

        static readonly List<eExcelconditionalFormattingCustomIcon> NoIcon =
             new List<eExcelconditionalFormattingCustomIcon>()
            {eExcelconditionalFormattingCustomIcon.NoIcon};

        internal static readonly Dictionary<string, List<eExcelconditionalFormattingCustomIcon>> IconSets
            = new Dictionary<string, List<eExcelconditionalFormattingCustomIcon>>
            {
                {"3Arrows", ThreeArrows },
                {"3ArrowsGray", ThreeArrowsGray },
                {"3Flags", ThreeFlags },
                {"3Signs", ThreeSigns },
                {"3Symbols", ThreeSymbols },
                {"3Symbols2", ThreeSymbols2 },
                {"3TrafficLights1", TrafficLights1 },
                {"3TrafficLights2", TrafficLights2 },
                {"3Stars", Stars },
                {"3Triangles", ThreeTriangles },
                {"4Arrows", FourArrows },
                {"4ArrowsGray", FourArrowsGray },
                {"4Rating", FourRating },
                {"4RedToBlack", FourRedToBlack },
                {"4TrafficLights", FourTrafficLights },
                {"5Arrows", FiveArrows },
                {"5ArrowsGray", FiveArrowsGray },
                {"5Quarters", FiveQuarters },
                {"5Rating", FiveRating },
                {"5Boxes", FiveBoxes },
                {"NoIcons",  NoIcon }
            };

        readonly static Dictionary<string, int> IconSetIndexedNames = new Dictionary<string, int>
            {
             { "3Arrows",  0 },
             { "3ArrowsGray" , 1 },
             { "3Flags" , 2 },
             { "3TrafficLights1" , 3 } ,
             { "3TrafficLights2" , 4 },
             { "3Signs" , 5 },
             { "3Symbols" , 6 },
             { "3Symbols2" , 7 },
             { "3Stars" , 8 },
             { "3Triangles" , 9 },
             { "4Arrows" , 10 },
             { "4ArrowsGray" , 11 },
             { "4RedToBlack" , 12 },
             { "4Rating" , 13 },
             { "4TrafficLights" , 14 },
             { "5Rating" , 15 },
             { "5Quarters" , 16 },
             { "5Boxes" , 17 },
             { "NoIcons" , 18},
            };

        internal static eExcelconditionalFormattingCustomIcon[] GetIconSet(string set)
        {
            var list = IconSets[set];
            return list.ToArray();
        }

        internal static eExcelconditionalFormattingCustomIcon GetIconAtIndex(string set, int index)
        {
            if(IconSets.ContainsKey(set) == false)
            {
                throw new KeyNotFoundException($"Key:{set} is not present in IconSets dictionary");
            }

            return IconSets[set][index];
        }

        internal static eExcelconditionalFormattingCustomIcon[] GetIconsAsCustomIcons(string iconsetStr, ExcelConditionalFormattingIconDataBarValue[] icons)
        {
            eExcelconditionalFormattingCustomIcon[] returnIcons = new eExcelconditionalFormattingCustomIcon[icons.Length];

            for (int i = 0; i < icons.Length; i++)
            {
                if (icons[i].CustomIcon == null)
                {
                    returnIcons[i] = GetIconAtIndex(iconsetStr, i);
                }
                else
                {
                    returnIcons[i] = icons[i].CustomIcon.Value;
                }
            }

            return returnIcons;
        }
    }
}
