# Contributing to EPPlus 5 

## Got a Question or Problem?
If you have questions about how to use EPPlus 5 and use the community license, please direct these to Stack Overflow.
If you are a customer with a commercial license, please sign in on https://epplussoftware.com and ask your question at our online support service.

## Found an Issue?
If you find a bug in the source code or a mistake in the documentation, you can help us by submitting a Pull Request with a fix.
Please see the Submission Guidelines below.

## Submission Guidelines
Before you submit your question or issue, search Stack Overflow, maybe your question was already answered.
If your issue appears to be a bug, please verify that it hasn't been reported before. 
If it's not reported create an issue in the issue tracker with a fully reproducible unit test including any Excel files necessary. 
If we can't reproduce the issue, we can't fix it!

## Pull requests
Anyone that want to contribute and submit a pull request are welcome to do so. Please note that for pull requests with more than 20 significant lines of code it's mandatory to sign the EPPlus CAA, for the pull request to be accepted. 	
This is not a complicated process. Just download the CAA form, sign it and mail it to github@epplussoftware.com. You only need to do this once either for you or your company. 

Our unit tests are still LGPL (as stated in the header of those code files). So the 20 lines are excluding unit tests.

### Larger pull requests
Larger pull requests are in general not likely to be accepted.

If you are considering to submit code that has significant impact on the EPPlus code base, please reach out to us first. You can do this by creating an issue in our issue tracker. "Significant impact" would include one of the following definitions:
- The pull request implements completely new features of EPPlus.
- The pull request contains changes in central parts of the software.
- The pull request would change the current behaviour of EPPlus.

If you have identified such a requirement we need to have a solid understanding of the issue before being able to advice the best way forward.

Please see our [CAA](https://epplussoftware.com/legal/caa) for more information.  
For branch naming see [Branching-strategy-and-CI](https://github.com/EPPlusSoftware/EPPlus/wiki/Branching-strategy-and-CI)
