# Contributing to kernl

## Who can participate?

**Everyone** is invited to participate in **kernl.ai**!

You don't have to be a developer or a Machine Learning practitioner. **Anyone can contribute in some way**, just have a
desire to **grow kernl.ai 🌱** or **strengthen it**.

## Why should I participate?

Kernl's goal is to **make models accessible** to more developers, **with efficiency** at heart.
In doing so, we not only **democratize large language models**, but also contribute to a more **resilient AI ecosystem**.

Participating allows you to contribute to the **beautiful adventure of kernl.ai** and to **its values**.
This way, you ensure that **the project you love is constantly improving**, **avoiding vendor lock-in**.

## What can I do?

It depends on what you want to do and your skills.

Contributing does not necessarily mean that you have to know how to code. Code is central, but it is only one part of the project.

There are a lot of things to do like :

- **Adding and fixing code**: This is the most obvious when you think about contributing. You can fix bugs, optimize already supported models, optimize new ones, add new features, etc.
- **Reporting bugs**: If you find a bug, you can report it in the **[issue tracker](https://github.com/ELS-RD/kernl/issues)** and help us fix it.
- **Improve documentation**: Documentation is essential for our users. You can help develop it, improve it, correct it. 
- **Manage contributions**: Of course, depending on your skills, you can help manage contributions. You can for example sort issues, answer questions, do code reviews, etc.
- **Submit ideas**: You can also submit ideas for new features, new models to optimize, etc.
- **UI/UX design**: User Experience is also essential, among other things to make kernl.ai even more accessible. You can contribute to it!

Of course, you can help spread the word and share the project to improve its visibility.

## Things to know before contributing

**Be respectful**. kernl.ai is a community project. Respect is essential. We are all here to help each other and to make kernl better.

We have adopted the **Contributor Covenant** as its **[Code of Conduct](code-of-conduct.md)**, and we expect project participants to adhere to it.

The **[Open Source Guides](https://opensource.guide/)** website has a collection of resources for individuals, communities, and companies who want to learn how to run and contribute to an open source project.
Contributors and people new to open source alike will find the following guides especially useful:

 - [x] **[How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)**
 - [x] **[Building Welcoming Communities](https://opensource.guide/building-community/)**

Kernl uses **[GitHub](https://github.com/ELS-RD/kernl)** as its source of truth.
A minimum level of knowledge about it is therefore required to start contributing.

## How do I know the contributing guidelines?

Just follow the **[contribution guidelines](how-to-contribute.md)**. 

