# Contributing Guide

This guide is designed to help you understand how Aluminum's workflow works and
get your pull requests successfully accepted and merged.

### How to Get Your Pull Request Accepted
There are two ways to get your pull request/feature request accepted into Aluminum.
They are:
1. Picking up a story in the Tracker project and working on it
1. Proposing a new feature through the issues tracker and getting it accepted on the Tracker project

Both methods require the feature in question to be in the Tracker project to be accepted.
Picking up an existing story or proposing a new feature (and getting it approved) ensure
that your pull request will get accepted.

Since not everyone has access to the Tracker project despite it being public, don't worry about
getting the story started in Tracker. Just open a tracking issue or pull request on the repo
so I know that you're working on something.

### The Pull Request Flow
Aluminum uses a pull request workflow. As a solo project, it seems a bit heavy but with
additional contributors it makes sense. All new features being as pull requests on separate
branches and are merged back in when the tests go green and the code coverage passes.

### TL;DR Show me the steps!
1. Grab a story from the Tracker project or an accepted feature request
1. Create tracking PR/issue
1. Implement feature using TDD (no tests == no PR merge)
1. Mark tracking PR as ready (i.e. comment on it)
1. Wait for brief code review
1. Merge! ... or sent back to be worked on more

Basically that's it!

### Getting Access to the Tracker Project
As individuals make more routine contributions, it's possible to be elevated to
maintainer status where you have write access to the repo and collaborator access
to the Tracker project. This would allow you to add new stories yourself, start stories,
and properly track your work on the project.

If you would like to become an elevated contributor/maintainer you must have contributed at
least once to the project and express interest in being added to the Tracker project.

This will be approved on a case-by-case basis.
