# Proton Exchange Membrane (PEM) Fuel Cell Dataset

## Overview

This dataset are about Nafion 112 membrane standard tests and MEA activation
tests of PEM fuel cell in various operation condition. Dataset include two general electrochemical
analysis method, Polarization and Impedance curves. In this dataset, effect of different pressure of
H2/O2 gas, different voltages and various humidity conditions in several steps are considered.
Behavior of PEM fuel cell during distinct operation condition tests, activation procedure and different operation condition
before and after activation analysis can be concluded from data. In Polarization curves, voltage
and power density change as a function of flows of H2/O2 and relative humidity. Resistance of the
used equivalent circuit of fuel cell can be calculated from Impedance data. Thus, experimental
response of the cell is obvious in the presented data, which is useful in depth analysis, simulation
and material performance investigation in PEM fuel cell researches.		

For more information about MEA(Membrane Electrode Assembly) activation procedure visit [here](https://github.com/ECSIM/pem-dataset1/tree/master/MEA.md)

## Tests


1. [Activation Test MEA Constant Current 0.25A](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Constant%20Current%200.25A)
2. [Activation Test MEA Constant Voltage 0.6V](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Constant%20Voltage%200.6V)
3. [Activation Test MEA Constant Voltage 0.6V-2](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Constant%20Voltage%200.6V-2)
4. [Activation Test MEA Constant Voltage 0.6V-3](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Constant%20Voltage%200.6V-3)
5. [Activation Test MEA Constant Voltage 0.6V-4](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Constant%20Voltage%200.6V-4)
6. [Activation Test MEA Cycling Potential](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Cycling%20Potential)
7. [Activation Test MEA Standard Protocol](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Standard%20Protocol)
8. [Activation Test MEA Standard Protocol (Repeat)](https://github.com/ECSIM/pem-dataset1/tree/master/Activation%20Test%20MEA%20Standard%20Protocol%20(Repeat))
9. [Standard Test of Nafion Membrane 112](https://github.com/ECSIM/pem-dataset1/tree/master/Standard%20Test%20of%20Nafion%20Membrane%20112)

<a href="https://github.com/ECSIM/pem-dataset1/archive/v1.1.zip"><img src="images/button.png" width="177px" height="34px"><a/>
<br/>
<a href="https://www.kaggle.com/sepandhaghighi/proton-exchange-membrane-pem-fuel-cell-dataset"><img src="images/button2.png" width="177px" height="34px"><a/>

## Notebooks

We have provided some **Jupyter Notebooks** to visualize the data, visit [here](https://github.com/ECSIM/pem-dataset1/tree/master/Notebooks)

## Issues & Bug Reports			

Just fill an issue and describe it. We'll check it ASAP!							
or send an email to [data@ecsim.site](mailto:data@ecsim.site "data@ecsim.site"). 

You can also join our discord server			

<a href="https://discord.gg/ZwrNZYVM4G">
  <img src="https://img.shields.io/discord/1006472275920425012.svg?style=for-the-badge" alt="Discord Channel">
</a>

## Cite

If you use this dataset in your research, we would appreciate citations to the following paper :

<pre>
S. Hamidi, S. Haghighi, K. Askari, Dataset of Standard Tests of Nafion 112 Membrane and Membrane Electrode Assembly (MEA) Activation Tests of Proton Exchange Membrane (PEM) Fuel Cell, ChemRxiv, (2020). doi:10.26434/chemrxiv.11902023.
</pre>
<pre>

@article{Hamidi2020,
  doi = {10.26434/chemrxiv.11902023},
  url = {https://doi.org/10.26434/chemrxiv.11902023},
  year = {2020},
  month = feb,
  publisher = {American Chemical Society ({ACS})},
  author = {Sarmin Hamidi and Sepand Haghighi and Kasra Askari},
  title = {Dataset of Standard Tests of Nafion 112 Membrane and Membrane Electrode Assembly ({MEA}) Activation Tests of Proton Exchange Membrane ({PEM}) Fuel Cell}
}


</pre>

## License


<a href="https://github.com/ECSIM/pem-dataset1/blob/master/LICENSE"><img src="images/CC-BY.png"></a>

## Show Your Support

<h3>Star This Repo</h3>					

Give a ⭐️ if this project helped you!  

<h3>Donate to Our Project</h3>	

If you do like our project and we hope that you do, can you please support us? Our project is not and is never going to be working for profit. We need the money just so we can continue doing what we do ;-) .

<a href="https://www.ecsim.site/opem/donate.html" target="_blank"><img src="http://www.ecsim.site/images/Donate-Button.png" height="90px" width="270px" alt="ECSIM Donation"></a>