# Membrane Electrode Assembly Activation Procedure

The start-up procedure for a new fuel cell membrane electrode assembly MEA may vary somewhat from application to application. What is important in any research or production environment is to be consistent with the break-in procedure that you use.  How the MEA is initially broken-in can have long lasting effects on the ultimate performance of the MEA.
Published procedures vary in specifics, but almost all follow a similar sequence:

1.	Initial Start-Up
2.	Load Cycling
3.	Final Performance

The [US Fuel Cell Council (USFCC)](http://www.usfcc.com/) published a standard for single cell testing that includes specific break-in procedures:

- Fuel: Hydrogen, 1.2 Stoich, 100% RH
- Oxidant: Air, 2.0 Stoich, 100% RH
- Temperature (C): 80°
- Pressures (psig): 25

**Initial Start-Up**:  As required to reach 80°C

1.	Cycle Step 1 (Perform Once): Hold 0.6V for 60 mins
2.	Cycling Step 2 (Perform 9 times): Hold 0.7V for 20 mins, than hold 0.5V for 20 mins
3.	Constant Current Operation: Hold at 200 mA/cm² for 720 mins (12 hrs)


Verify break-in status by repeating the polarization curve sequence three times, or as necessary, to ensure that the cell is broken-in. Remain at each sequence step for 20 minutes. The cell is considered broken-in when less than a 5 mV deviation from the previous polarization curve is recorded at 800 mA/cm². A wait period of 10 minutes should be observed between polarization curves. During this period, return the gas flow rates to the equivalent of 10 stoich at 200 mA/cm² and set the current to 800 mA/cm².

## Reference

- [https://fuelcellsetc.com/2013/04/membrane-electrode-assembly-mea-activation-procedures/](https://fuelcellsetc.com/2013/04/membrane-electrode-assembly-mea-activation-procedures/)



