# vbConsoleGameEngine

The official distribution of *vbConsoleGameEngine*.

Provides a relatively "primitive" pixel drawing and user interface framework for:

- The development of games.
- Visualization of algorithms.
- Prototyping and experimentation.
- Education.
- Following along with [javidx9](https://www.youtube.com/@javidx9)'s videos, using VB!
- Abusing the Windows Console window (CMD).

*vbConsoleGameEngine* road map (in no particular order):

- Continue adding / implementing (to reach parity as of 02/07/2018).
- Publish as a nuget package?
- Add documentation.

*vbConsoleGameEngine* is heavily inspired by [olc::ConsoleGameEngine](https://github.com/OneLoneCoder); specifically the 02/07/2018 version. Even more specifically, I've developed this project while following along with [javidx9](https://www.youtube.com/@javidx9) videos; so very likely that not all features in 02/07/2018 have been implemented at parity.

*vbConsoleGameEngine* is used by 1s of programmers at *some* level of ability! ;-)

## History

I stumbled across [OneLoneCoder](https://github.com/OneLoneCoder) and I couldn't resist the idea of abusing the Command Prompt to act as graphics output device; however, all of his code is written in C++. So the only way that I could jump in an play with this is to either do it in C++ or, well, rewrite it all in VB. As you can probably guess, I chose the later.

It appears that the utilization of *olc::ConsoleGameEngine* in the [javidx9](https://www.youtube.com/@javidx9) videos as come to an end in favor of [olc::PixelGameEngine](https://github.com/OneLoneCoder/olcPixelGameEngine). With that said, I still highly recommend watching the earlier videos and the simple fact that all of this is being done in a Console Window makes it all the more worthwhile.

## Discord

Please reach out to me on Discord:

- [Discord Invite](https://discord.gg/Y8EH5fF6WG)

## Documentation

Please see [wiki](https://github.com/DualBrain/vbConsoleGameEngine/wiki).

*Note: If you haven't figured it out, this project - although does indeed work - isn't designed for any sort of production work. As a means of flexing geek muscles, absolutely... but one shouldn't take this project too seriously as it is literally abusing the Command Prompt (CMD) window and there are certain limitations that will never be able to be avoided. With that said, it shouldn't detract from how impressively cool doing this sort of thing is and full credit should go to OneLoneCoder for demonstrating how to accomplish thus.*
